/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.data.server.AoASkillReqReloadListener;

public class SkillRequirementDataPacket
implements AoAPacket {
    private final Map<ResourceLocation, Map<String, List<Pair<ResourceLocation, Integer>>>> requirementData;

    public SkillRequirementDataPacket(Map<ResourceLocation, Map<String, List<Pair<ResourceLocation, Integer>>>> requirementData) {
        this.requirementData = requirementData;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.requirementData.size());
        for (Map.Entry<ResourceLocation, Map<String, List<Pair<ResourceLocation, Integer>>>> entry : this.requirementData.entrySet()) {
            Map<String, List<Pair<ResourceLocation, Integer>>> reqEntry = entry.getValue();
            buffer.m_130085_(entry.getKey());
            buffer.m_130130_(reqEntry.size());
            for (Map.Entry<String, List<Pair<ResourceLocation, Integer>>> reqTypeEntry : reqEntry.entrySet()) {
                List<Pair<ResourceLocation, Integer>> reqs = reqTypeEntry.getValue();
                buffer.m_130070_(reqTypeEntry.getKey());
                buffer.m_130130_(reqs.size());
                for (Pair<ResourceLocation, Integer> req : reqs) {
                    buffer.m_130085_((ResourceLocation)req.getFirst());
                    buffer.m_130130_(((Integer)req.getSecond()).intValue());
                }
            }
        }
    }

    public static SkillRequirementDataPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        HashMap<ResourceLocation, Map<String, List<Pair<ResourceLocation, Integer>>>> data = new HashMap<ResourceLocation, Map<String, List<Pair<ResourceLocation, Integer>>>>(size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation itemId = buffer.m_130281_();
            int reqTypesSize = buffer.m_130242_();
            HashMap reqTypesMap = new HashMap(reqTypesSize);
            for (int j = 0; j < reqTypesSize; ++j) {
                String typeId = buffer.m_130277_();
                int typeSize = buffer.m_130242_();
                ArrayList<Pair> reqs = new ArrayList<Pair>(typeSize);
                for (int k = 0; k < typeSize; ++k) {
                    reqs.add(Pair.of((Object)buffer.m_130281_(), (Object)buffer.m_130242_()));
                }
                reqTypesMap.put(typeId, reqs);
            }
            data.put(itemId, reqTypesMap);
        }
        return new SkillRequirementDataPacket(data);
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> AoASkillReqReloadListener.parseAll(this.requirementData));
        context.get().setPacketHandled(true);
    }
}

