/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.library.builder.ParticleBuilder;

public class ServerParticlePacket
implements AoAPacket {
    private final List<ParticleBuilder> particles;

    public ServerParticlePacket() {
        this(1);
    }

    public ServerParticlePacket(int amount) {
        this((List<ParticleBuilder>)new ObjectArrayList(amount));
    }

    public ServerParticlePacket(List<ParticleBuilder> particles) {
        this.particles = particles;
    }

    public ServerParticlePacket(ParticleBuilder ... particles) {
        this((List<ParticleBuilder>)ObjectArrayList.of((Object[])particles));
    }

    public ServerParticlePacket particle(ParticleBuilder particle) {
        this.particles.add(particle);
        return this;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_236828_(this.particles, (buf, builder) -> builder.toNetwork((FriendlyByteBuf)buf));
    }

    public static ServerParticlePacket decode(FriendlyByteBuf buffer) {
        return new ServerParticlePacket((List)buffer.m_236838_(ObjectArrayList::new, ParticleBuilder::fromNetwork));
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            for (ParticleBuilder builder : this.particles) {
                builder.spawnParticles();
            }
        });
        context.get().setPacketHandled(true);
    }
}

