/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.client.gui.overlay.ScreenEffectRenderer;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.library.constant.ScreenImageEffect;

public class ScreenEffectPacket
implements AoAPacket {
    private final ScreenImageEffect effect;

    public ScreenEffectPacket(ScreenImageEffect effect) {
        this.effect = effect;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.effect.getType().ordinal());
        buffer.writeFloat(this.effect.getScale());
        buffer.m_130130_(this.effect.getColour());
        buffer.m_130130_(this.effect.getDuration());
        buffer.writeBoolean(this.effect.isFullscreen());
    }

    public static ScreenEffectPacket decode(FriendlyByteBuf buffer) {
        return new ScreenEffectPacket(new ScreenImageEffect(ScreenImageEffect.Type.values()[buffer.m_130242_()]).scaled(buffer.readFloat()).coloured(buffer.m_130242_()).duration(buffer.m_130242_()).fullscreen(buffer.readBoolean()));
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        ScreenEffectRenderer.addScreenEffect(this.effect);
        context.get().setPacketHandled(true);
    }
}

