/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.event.AoAPlayerEvents;

public class PlayerAbilityKeybindPacket
implements AoAPacket {
    private final List<String> abilities;

    public PlayerAbilityKeybindPacket(List<String> abilities) {
        this.abilities = abilities;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.abilities.size());
        for (String st : this.abilities) {
            buffer.m_130070_(st);
        }
    }

    public static PlayerAbilityKeybindPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<String> abilities = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            abilities.add(buffer.m_130277_());
        }
        return new PlayerAbilityKeybindPacket(abilities);
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> AoAPlayerEvents.onKeyPress(((NetworkEvent.Context)context.get()).getSender(), this.abilities));
        context.get().setPacketHandled(true);
    }
}

