/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.packet.packets.AoAPacket;

public class PatchouliBookSyncPacket
implements AoAPacket {
    private final ArrayList<ResourceLocation> books;

    public PatchouliBookSyncPacket(ArrayList<ResourceLocation> books) {
        this.books = books;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.books.size());
        for (ResourceLocation id : this.books) {
            buffer.m_130085_(id);
        }
    }

    public static PatchouliBookSyncPacket decode(FriendlyByteBuf buffer) {
        int bookCount = buffer.m_130242_();
        ArrayList<ResourceLocation> books = new ArrayList<ResourceLocation>(bookCount);
        for (int i = 0; i < bookCount; ++i) {
            books.add(buffer.m_130281_());
        }
        return new PatchouliBookSyncPacket(books);
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        ClientOperations.syncPatchouliBooks(this.books);
        context.get().setPacketHandled(true);
    }
}

