/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.aoa3.util.DamageUtil;

public class ParticleEffectPacket
implements AoAPacket {
    private final Type type;
    private final int senderId;
    private final int entityId;

    public ParticleEffectPacket(Type type, int senderId, int entityId) {
        this.type = type;
        this.senderId = senderId;
        this.entityId = entityId;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.type.ordinal());
        buffer.m_130130_(this.senderId);
        buffer.m_130130_(this.entityId);
    }

    public static ParticleEffectPacket decode(FriendlyByteBuf buffer) {
        return new ParticleEffectPacket(Type.values()[buffer.m_130242_()], buffer.m_130242_(), buffer.m_130242_());
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        switch (this.type) {
            case FREEZING_SNOWFLAKE: {
                ServerLevel level = context.get().getSender().m_9236_();
                Entity entity = level.m_6815_(this.entityId);
                Entity attacker = null;
                if (entity == null) break;
                if (this.senderId > 0) {
                    attacker = level.m_6815_(this.senderId);
                }
                if (attacker instanceof AoARangedAttacker) {
                    AoARangedAttacker rangedAttacker = (AoARangedAttacker)attacker;
                    rangedAttacker.doRangedAttackEntity(null, entity);
                    break;
                }
                if (!((float)entity.m_146888_() <= (float)entity.m_146891_() * 2.5f)) break;
                entity.m_146917_(entity.m_146888_() + 14);
                break;
            }
            case SANDSTORM: {
                Entity attacker;
                ServerLevel level = context.get().getSender().m_9236_();
                Entity entity = level.m_6815_(this.entityId);
                Entity entity2 = attacker = this.senderId >= 0 ? level.m_6815_(this.senderId) : null;
                if (entity instanceof LivingEntity) {
                    if (!EntityPredicate.TARGETABLE_ENTITIES.test(entity)) break;
                    DamageSource source = attacker == null ? DamageUtil.miscDamage((ResourceKey<DamageType>)DamageTypes.f_268656_, entity.f_19853_) : DamageUtil.positionedEntityDamage((ResourceKey<DamageType>)DamageTypes.f_268511_, attacker, entity.m_20182_());
                    DamageUtil.safelyDealDamage(source, entity, 4.0f);
                    break;
                }
                if (!(entity instanceof Projectile)) break;
                entity.m_20256_(entity.m_20184_().m_82542_(-0.5, -0.5, -0.5));
                break;
            }
            case BURNING_FLAME: {
                ServerLevel level = context.get().getSender().m_9236_();
                Entity entity = level.m_6815_(this.entityId);
                if (!(entity instanceof LivingEntity)) break;
                Entity attacker = null;
                if (this.senderId > 0) {
                    attacker = level.m_6815_(this.senderId);
                }
                if (attacker instanceof AoARangedAttacker) {
                    AoARangedAttacker rangedAttacker = (AoARangedAttacker)attacker;
                    rangedAttacker.doRangedAttackEntity(null, entity);
                    break;
                }
                DamageUtil.safelyDealDamage(DamageUtil.miscPositionedDamage(AoADamageTypes.BURN, entity.f_19853_, entity.m_20182_()), entity, 1.0f);
                entity.m_20254_((int)Math.ceil((float)entity.m_20094_() / 20.0f) + 1);
            }
        }
    }

    public static enum Type {
        FREEZING_SNOWFLAKE,
        BURNING_FLAME,
        SANDSTORM;

    }
}

