/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.container;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class CustomResultSlot<C extends Container, T extends Recipe<C>>
extends Slot {
    private final RecipeType<T> recipeType;
    private final C craftSlots;
    private final Player player;
    private int removeCount;

    public CustomResultSlot(Player player, C craftSlots, Container container, RecipeType<T> recipeType, int slot, int xPosition, int yPosition) {
        super(container, slot, xPosition, yPosition);
        this.craftSlots = craftSlots;
        this.player = player;
        this.recipeType = recipeType;
    }

    public boolean m_5857_(ItemStack stack) {
        return false;
    }

    public ItemStack m_6201_(int amount) {
        if (this.m_6657_()) {
            this.removeCount += Math.min(amount, this.m_7993_().m_41613_());
        }
        return super.m_6201_(amount);
    }

    protected void m_7169_(ItemStack stack, int amount) {
        this.removeCount += amount;
        this.m_5845_(stack);
    }

    protected void m_6405_(int numItemsCrafted) {
        this.removeCount += numItemsCrafted;
    }

    protected void m_5845_(ItemStack stack) {
        Container container;
        if (this.removeCount > 0) {
            stack.m_41678_(this.player.f_19853_, this.player, this.removeCount);
            ForgeEventFactory.firePlayerCraftingEvent((Player)this.player, (ItemStack)stack, this.craftSlots);
        }
        if ((container = this.f_40218_) instanceof RecipeHolder) {
            RecipeHolder recipeHolder = (RecipeHolder)container;
            recipeHolder.m_8015_(this.player);
        }
        this.removeCount = 0;
    }

    public void m_142406_(Player player, ItemStack stack) {
        this.m_5845_(stack);
        ForgeHooks.setCraftingPlayer((Player)player);
        NonNullList remainingItems = player.f_19853_.m_7465_().m_44069_(this.recipeType, this.craftSlots, player.f_19853_);
        ForgeHooks.setCraftingPlayer(null);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack slotStack = this.craftSlots.m_8020_(i);
            ItemStack remainingStack = (ItemStack)remainingItems.get(i);
            if (!slotStack.m_41619_()) {
                this.craftSlots.m_7407_(i, 1);
                slotStack = this.craftSlots.m_8020_(i);
            }
            if (remainingStack.m_41619_()) continue;
            if (slotStack.m_41619_()) {
                this.craftSlots.m_6836_(i, remainingStack);
                continue;
            }
            if (ItemStack.m_41746_((ItemStack)slotStack, (ItemStack)remainingStack) && ItemStack.m_41658_((ItemStack)slotStack, (ItemStack)remainingStack)) {
                remainingStack.m_41769_(slotStack.m_41613_());
                this.craftSlots.m_6836_(i, remainingStack);
                continue;
            }
            if (this.player.m_150109_().m_36054_(remainingStack)) continue;
            this.player.m_36176_(remainingStack, false);
        }
    }
}

