/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tslat.aoa3.command.AoACommand;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.WikiSearchPacket;
import net.tslat.aoa3.util.StringUtil;

public class WikiCommand
implements Command<CommandSourceStack> {
    private static final WikiCommand CMD = new WikiCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"wiki").executes((Command)CMD);
        builder.then(((RequiredArgumentBuilder)Commands.m_82129_((String)"search", (ArgumentType)StringArgumentType.greedyString()).requires(command -> command.m_6761_(0))).executes(WikiCommand::sendPacket));
        return builder;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleSearchRequest(String search) {
        Object targetUrl = "?";
        String pageTitle = StringUtil.toTitleCase(search);
        if (search.equalsIgnoreCase("random")) {
            search = "Special:Random";
        }
        try {
            int titleIndex;
            targetUrl = "https://adventofascension.gamepedia.com/index.php?search=" + URLEncoder.encode(search, StandardCharsets.UTF_8) + "&title=Special:Search&go=Go";
            HttpURLConnection connection = (HttpURLConnection)new URL("https://adventofascension.gamepedia.com/" + StringUtil.toTitleCase(URLEncoder.encode(search, StandardCharsets.UTF_8).replace("+", " ")).replace(" ", "_")).openConnection();
            if (connection.getResponseCode() == 200 && (titleIndex = ((String)(targetUrl = connection.getURL().toString())).indexOf("wiki/")) >= 0) {
                pageTitle = StringUtil.toTitleCase(((String)targetUrl).substring(titleIndex + 5));
            }
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException ex) {
            Minecraft.m_91087_().f_91074_.m_213846_((Component)AoACommand.getCmdPrefix("Wiki").m_7220_((Component)Component.m_237115_((String)"command.aoa.wiki.connectionFail").m_6270_(Style.f_131099_.m_131157_(AoACommand.CommandFeedbackType.ERROR.getColour()))));
        }
        if (search.equals("Special:Random")) {
            pageTitle = "???";
        }
        MutableComponent responseComponent = WikiCommand.getComponentFromKeys("command.aoa.wiki.response", (String)targetUrl, pageTitle);
        Minecraft.m_91087_().f_91074_.m_213846_((Component)AoACommand.getCmdPrefix("Wiki").m_7220_((Component)(responseComponent != null ? responseComponent.m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)) : Component.m_237110_((String)"command.aoawiki.response", (Object[])new Object[]{targetUrl}))));
    }

    @Nullable
    private static MutableComponent getComponentFromKeys(String langKey, String url, String pageTitle) {
        return Component.Serializer.m_130701_((String)("{\"translate\":\"" + langKey + "\",\"with\":[{\"text\":\"" + pageTitle + "\",\"color\":\"red\",\"underlined\":true,\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + url + "\"}}]}"));
    }

    private static int sendPacket(CommandContext<CommandSourceStack> cmd) throws CommandSyntaxException {
        AoAPackets.messagePlayer((ServerPlayer)((CommandSourceStack)cmd.getSource()).m_81374_(), new WikiSearchPacket(StringArgumentType.getString(cmd, (String)"search")));
        return 1;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        AoACommand.feedback((CommandSourceStack)context.getSource(), "Wiki", "command.aoa.wiki.desc", AoACommand.CommandFeedbackType.INFO, new Component[0]);
        return 1;
    }
}

