/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ModelledProjectileRenderer<T extends Entity>
extends EntityRenderer<T> {
    private final ResourceLocation texture;
    protected final EntityModel<? super T> model;

    public ModelledProjectileRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayerLocation, Function<ModelPart, EntityModel<? super T>> model, ResourceLocation texture) {
        super(context);
        this.model = model.apply(context.m_174023_(modelLayerLocation));
        this.texture = texture;
    }

    public void m_7392_(T entity, float yaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
        matrix.m_85836_();
        matrix.m_85841_(-1.0f, -1.0f, 1.0f);
        this.preRenderCallback(entity, matrix, partialTicks);
        float pitch = Mth.m_14179_((float)partialTicks, (float)((Entity)entity).f_19860_, (float)entity.m_146909_());
        this.model.m_6839_(entity, 0.0f, 0.0f, partialTicks);
        this.model.m_6973_(entity, 0.0f, partialTicks, (float)((Entity)entity).f_19797_, 0.0f, pitch);
        matrix.m_85837_(0.0, (double)-1.6f, 0.0);
        boolean visible = !entity.m_20145_();
        boolean shade = !visible && !entity.m_20177_((Player)Minecraft.m_91087_().f_91074_);
        RenderType rendertype = this.getRenderType(entity, visible, shade);
        if (rendertype != null) {
            VertexConsumer vertexConsumer = buffer.m_6299_(rendertype);
            this.model.m_7695_(matrix, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, shade ? 0.15f : 1.0f);
        }
        matrix.m_85849_();
        super.m_7392_(entity, yaw, partialTicks, matrix, buffer, packedLight);
    }

    @Nullable
    protected RenderType getRenderType(T entity, boolean visible, boolean shade) {
        ResourceLocation texture = this.m_5478_(entity);
        if (shade) {
            return RenderType.m_110473_((ResourceLocation)texture);
        }
        if (visible) {
            return this.model.m_103119_(texture);
        }
        return entity.m_142038_() ? RenderType.m_110491_((ResourceLocation)texture) : null;
    }

    protected void preRenderCallback(T entity, PoseStack matrix, float partialTicks) {
    }

    public ResourceLocation m_5478_(T entity) {
        return this.texture;
    }
}

