/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.misc;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.eventbus.api.EventPriority;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.util.ColourUtil;

public final class OccultBlockRenderer {
    private static final RenderType RENDER_TYPE = RenderType.m_173215_((String)"occult_block_lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(5.0))).m_110685_(RenderStateShard.f_110139_).m_110675_(RenderStateShard.f_110124_).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110691_(false));
    private static final CopyOnWriteArrayList<IntObjectPair<List<OccultBlock>>> OCCULT_BLOCKS = new CopyOnWriteArrayList();

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, RenderLevelStageEvent.class, OccultBlockRenderer::onWorldRender);
    }

    public static void addOccultBlocks(int renderUntil, List<OccultBlock> blocks) {
        OCCULT_BLOCKS.add((IntObjectPair<List<OccultBlock>>)IntObjectPair.of((int)renderUntil, blocks));
    }

    private static void onWorldRender(RenderLevelStageEvent ev) {
        if (ev.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES || OCCULT_BLOCKS.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        boolean rendered = false;
        PoseStack matrix = ev.getPoseStack();
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        VertexConsumer buffer = mc.m_91269_().m_110104_().m_6299_(RENDER_TYPE);
        matrix.m_85836_();
        matrix.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        PoseStack.Pose pose = matrix.m_85850_();
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_69478_();
        OCCULT_BLOCKS.removeIf(entry -> GlobalEvents.tick >= entry.leftInt());
        for (IntObjectPair<List<OccultBlock>> entry2 : OCCULT_BLOCKS) {
            Iterator iterator = ((List)entry2.right()).iterator();
            while (iterator.hasNext()) {
                OccultBlock block = (OccultBlock)iterator.next();
                if (GlobalEvents.tick % 2 == 1 && mc.f_91074_.f_19853_.m_8055_(block.pos) != block.state) {
                    iterator.remove();
                    continue;
                }
                BlockPos pos = block.pos;
                VoxelShape shape = block.state.m_60651_((BlockGetter)mc.f_91073_, pos, CollisionContext.m_82750_((Entity)mc.f_91074_));
                ColourUtil.Colour colour = block.colour;
                rendered = true;
                shape.m_83224_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    float lengthX = (float)(maxX - minX);
                    float lengthY = (float)(maxY - minY);
                    float lengthZ = (float)(maxZ - minZ);
                    float length = Mth.m_14116_((float)(lengthX * lengthX + lengthY * lengthY + lengthZ * lengthZ));
                    buffer.m_252986_(pose.m_252922_(), (float)minX + (float)pos.m_123341_(), (float)minY + (float)pos.m_123342_(), (float)minZ + (float)pos.m_123343_()).m_85950_(colour.red(), colour.green(), colour.blue(), colour.alpha()).m_252939_(pose.m_252943_(), lengthX /= length, lengthY /= length, lengthZ /= length).m_5752_();
                    buffer.m_252986_(pose.m_252922_(), (float)maxX + (float)pos.m_123341_(), (float)maxY + (float)pos.m_123342_(), (float)maxZ + (float)pos.m_123343_()).m_85950_(colour.red(), colour.green(), colour.blue(), colour.alpha()).m_252939_(pose.m_252943_(), lengthX, lengthY, lengthZ).m_5752_();
                });
            }
        }
        matrix.m_85849_();
        RenderSystem.m_69860_((int)1032, (int)6914);
        RenderSystem.m_69461_();
        RenderSystem.m_69482_();
        RenderSystem.m_69458_((boolean)true);
        if (rendered) {
            mc.m_91269_().m_110104_().m_109911_();
        }
    }

    private static ColourUtil.Colour getColourForBlock(BlockState block) {
        List tiers = TierSortingRegistry.getSortedTiers();
        float tierCount = tiers.size();
        int i = 0;
        while ((float)i < tierCount) {
            Tier tier = (Tier)tiers.get(i);
            if (TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)block)) {
                return new ColourUtil.Colour(1.0f - (float)i / tierCount, (float)i / tierCount, 0.0f, 0.85f);
            }
            ++i;
        }
        return new ColourUtil.Colour(0.0f, 1.0f, 0.0f, 1.0f);
    }

    public record OccultBlock(ColourUtil.Colour colour, BlockPos pos, BlockState state) {
        public OccultBlock(BlockPos pos, BlockState state) {
            this(OccultBlockRenderer.getColourForBlock(state), pos, state);
        }
    }
}

