/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.particle;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.client.particle.EntityAffectingParticle;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ParticleEffectPacket;
import net.tslat.aoa3.common.particletype.CustomisableParticleType;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class SandstormParticle
extends EntityAffectingParticle {
    private final SpriteSet sprite;
    private final int senderId;

    protected SandstormParticle(ClientLevel world, double posX, double posY, double posZ, double velocityX, double velocityY, double velocityZ, SpriteSet sprite, float scale, float ageModifier, int entitySourceId) {
        super(world, posX, posY, posZ, velocityX, velocityY, velocityZ);
        this.sprite = sprite;
        this.f_107215_ = velocityX;
        this.f_107216_ = velocityY;
        this.f_107217_ = velocityZ;
        this.f_107663_ = (this.f_107223_.m_188501_() * this.f_107223_.m_188501_() * 6.0f + 1.0f) * scale / 5.0f;
        this.f_107225_ = (int)Math.ceil((double)ageModifier / ((double)this.f_107223_.m_188501_() * 0.8 + 0.2));
        this.senderId = entitySourceId;
        this.f_107227_ = (float)RandomUtil.randomValueBetween((double)0.95f, (double)1.0);
        this.f_107228_ = (float)RandomUtil.randomValueBetween((double)0.7f, (double)0.85f);
        this.f_107229_ = (float)RandomUtil.randomValueBetween((double)0.45f, (double)0.55f);
        if (this.f_107230_ == 0.0f) {
            this.f_107230_ = 1.0f;
        }
        this.m_108337_(sprite.m_213979_((RandomSource)RandomUtil.RANDOM));
        this.m_107250_(0.1f, 0.1f);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    @Override
    protected boolean handleCollision(Entity collidedEntity) {
        if (EntityPredicate.DAMAGEABLE_ENTITIES.test(collidedEntity) || collidedEntity instanceof Projectile) {
            AoAPackets.messageServer(new ParticleEffectPacket(ParticleEffectPacket.Type.SANDSTORM, this.senderId, collidedEntity.m_19879_()));
        }
        return true;
    }

    @Override
    @Nullable
    protected Entity getCollidedEntity(double xVelocity, double yVelocity, double zVelocity) {
        if (this.senderId == -1) {
            return null;
        }
        return EntityRetrievalUtil.getNearestEntity((Level)this.f_107208_, (AABB)this.m_107277_().m_82363_(xVelocity, yVelocity, zVelocity), (Vec3)new Vec3(this.f_107212_, this.f_107213_, this.f_107214_), (Predicate)EntityPredicate.TARGETABLE_ENTITIES.and(entity -> entity.m_19879_() != this.senderId));
    }

    public static class Factory
    implements ParticleProvider<CustomisableParticleType.Data> {
        private final SpriteSet sprite;

        public Factory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(CustomisableParticleType.Data data, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new SandstormParticle(world, x, y, z, velocityX, velocityY, velocityZ, this.sprite, data.scale, data.ageModifier, data.entitySourceId);
        }
    }
}

