/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.particle;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.particletype.CustomisableParticleType;

public class FireAuraParticle
extends TextureSheetParticle {
    private final Entity entity;
    private double startX;
    private double startY;
    private double startZ;

    public FireAuraParticle(ClientLevel world, double posX, double posY, double posZ, double velocityX, double velocityY, double velocityZ, SpriteSet sprite, float scale, float ageModifier, int entitySourceId) {
        super(world, posX, posY, posZ, velocityX, velocityY, velocityZ);
        this.f_107215_ = velocityX;
        this.f_107216_ = velocityY;
        this.f_107217_ = velocityZ;
        this.f_107663_ = (this.f_107223_.m_188501_() * this.f_107223_.m_188501_() * 6.0f + 1.0f) * scale / 5.0f;
        this.f_107225_ = (int)Math.ceil((double)(ageModifier * 5.0f) / ((double)this.f_107223_.m_188501_() * 0.8 + 0.2));
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.f_107230_ = 1.0f;
        this.f_107219_ = false;
        this.entity = this.f_107208_.m_6815_(entitySourceId);
        if (this.entity != null) {
            this.startX = this.entity.m_20185_();
            this.startY = this.entity.m_20227_(0.5);
            this.startZ = this.entity.m_20189_();
        }
        this.m_108335_(sprite);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107432_;
    }

    public int m_6355_(float partialTick) {
        float lerpAge = Mth.m_14036_((float)(((float)this.f_107224_ + partialTick) / (float)this.f_107225_), (float)0.0f, (float)1.0f) * 240.0f;
        int baseColour = super.m_6355_(partialTick);
        int colourMod = (baseColour & 0xFF) + (int)lerpAge;
        if (colourMod > 240) {
            colourMod = 240;
        }
        return colourMod | (baseColour >> 16 & 0xFF) << 16;
    }

    public void m_5989_() {
        if (this.entity == null || !this.entity.m_6084_()) {
            this.m_107274_();
            return;
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        double slope = Math.toRadians(20.0);
        double angleX = Math.cos(slope);
        double angleZ = Math.sin(slope);
        double angleY = Math.cos(angleX + angleZ);
        Vec3 rotDelta = new Vec3(angleX * (this.f_107212_ - this.startX) - angleZ * (this.f_107214_ - this.startZ), angleY * (this.f_107213_ - this.startY) * Math.tan(angleX + angleZ), angleZ * (this.f_107212_ - this.startX) + angleX * (this.f_107214_ - this.startZ)).m_82541_().m_82490_(2.0).m_82520_(this.startX, this.startY, this.startZ);
        this.f_107215_ = rotDelta.f_82479_ - this.f_107212_;
        this.f_107216_ = rotDelta.f_82480_ - this.f_107213_;
        this.f_107217_ = rotDelta.f_82481_ - this.f_107214_;
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    public static class Factory
    implements ParticleProvider<CustomisableParticleType.Data> {
        private final SpriteSet sprite;

        public Factory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(CustomisableParticleType.Data data, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new FireAuraParticle(world, x, y, z, velocityX, velocityY, velocityZ, this.sprite, data.scale, data.ageModifier, data.entitySourceId);
        }
    }
}

