/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.realmstone;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.common.util.Lazy;
import net.tslat.aoa3.data.client.RealmstoneInsertsReloadListener;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RenderUtil;

public class BlankRealmstoneScreen
extends Screen {
    private static final ResourceLocation background = new ResourceLocation("aoa3", "textures/gui/realmstonegui/background.png");
    private static final ResourceLocation windowFrame = new ResourceLocation("aoa3", "textures/gui/realmstonegui/window_frame.png");
    private static final ResourceLocation widgets = new ResourceLocation("aoa3", "textures/gui/realmstonegui/widgets.png");
    private static final Random rand = new Random(0L);
    private static final int backgroundHeight = 2000;
    private static final int backgroundWidth = 2000;
    private static final int viewSpaceWidth = 238;
    private static final int viewSpaceHeight = 166;
    private static float scale = 0.5f;
    private final HashMap<String, RealmstoneWorldInsert> worldInserts = new HashMap(23);
    private static RealmstoneWorldInsert currentlyHoveredInsert = null;
    private boolean isPanning = false;
    private int panMouseX = 0;
    private int panMouseY = 0;
    private int offsetX = 639;
    private int offsetY = 579;

    public BlankRealmstoneScreen() {
        super((Component)LocaleUtil.getLocaleMessage("gui.aoa3.realmstone.title"));
        scale = 0.5f;
        this.worldInserts.putAll(RealmstoneInsertsReloadListener.INSERTS);
    }

    public void m_86412_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.f_96541_ == null) {
            return;
        }
        int x = (this.f_96543_ - 252) / 2;
        int y = (this.f_96544_ - 182) / 2;
        currentlyHoveredInsert = null;
        if (this.m_7282_()) {
            if (!this.isPanning) {
                this.panMouseX = mouseX;
                this.panMouseY = mouseY;
            }
            this.isPanning = true;
            this.offsetX = Mth.m_14045_((int)(this.offsetX + (int)((float)(this.panMouseX - mouseX) / scale)), (int)0, (int)(2000 - (int)(238.0f / scale)));
            this.offsetY = Mth.m_14045_((int)(this.offsetY + (int)((float)(this.panMouseY - mouseY) / scale)), (int)0, (int)(2000 - (int)(166.0f / scale)));
            this.panMouseX = mouseX;
            this.panMouseY = mouseY;
        } else {
            this.isPanning = false;
            this.panMouseX = 0;
            this.panMouseY = 0;
        }
        this.m_7333_(matrix);
        matrix.m_85836_();
        matrix.m_85841_(scale, scale, scale);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)background);
        RenderUtil.renderCustomSizedTexture(matrix, (int)((float)(x + 5) / scale), (int)((float)(y + 7) / scale), this.offsetX, this.offsetY, (int)(238.0f / scale), (int)(166.0f / scale), 2000.0f, 2000.0f);
        for (RealmstoneWorldInsert insert : this.worldInserts.values()) {
            insert.render(matrix, this.f_96541_, this.worldInserts, (int)((float)(x + 5) / scale), (int)((float)(y + 7) / scale), this.offsetX, this.offsetY, (int)((float)mouseX / scale), (int)((float)mouseY / scale));
        }
        matrix.m_85849_();
        this.drawWindowFrame(matrix, x, y);
        if (currentlyHoveredInsert != null && !currentlyHoveredInsert.getHoverTexts().isEmpty()) {
            this.m_96617_(matrix, currentlyHoveredInsert.getHoverTexts(), mouseX, mouseY);
        }
    }

    private void drawWindowFrame(PoseStack matrix, int x, int y) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)windowFrame);
        RenderUtil.renderCustomSizedTexture(matrix, x, y, 0.0f, 0.0f, 256.0f, 187.0f, 256.0f, 256.0f);
        this.f_96541_.f_91062_.m_92889_(matrix, this.f_96539_, (float)(x + 8), (float)(y + 6), ColourUtil.RGB(181, 181, 181));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int left = (this.f_96543_ - 256) / 2;
        int bottom = (this.f_96544_ - 186) / 2;
        if (mouseX >= (double)left && mouseX <= (double)(left + 256) && mouseY >= (double)bottom && mouseY <= (double)(bottom + 186)) {
            this.m_7897_(true);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.m_7897_(false);
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollAmount) {
        scale = (float)((double)scale + scrollAmount / 100.0);
        scale = (float)Mth.m_14008_((double)scale, (double)0.14, (double)1.3);
        this.offsetX = Math.min(this.offsetX, 2000 - (int)(238.0f / scale));
        this.offsetY = Math.min(this.offsetY, 2000 - (int)(166.0f / scale));
        return true;
    }

    public static class RealmstoneWorldInsert {
        private static final int iconSize = 100;
        private final String id;
        private final ResourceLocation texture;
        private final int posX;
        private final int posY;
        private final String[] parentNodes;
        private final Lazy<ArrayList<FormattedCharSequence>> hoverTexts;

        public RealmstoneWorldInsert(String id, int posX, int posY, String ... parentNodes) {
            this.id = id;
            this.posX = posX;
            this.posY = posY;
            this.parentNodes = parentNodes;
            this.texture = new ResourceLocation("aoa3", "textures/gui/realmstonegui/worlds/" + id + ".png");
            this.hoverTexts = Lazy.of(() -> {
                ArrayList<FormattedCharSequence> texts = new ArrayList<FormattedCharSequence>(2);
                texts.add(LocaleUtil.getLocaleMessage("dimension.aoa3." + id, ChatFormatting.BLUE, new Component[0]).m_7532_());
                texts.addAll(Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)LocaleUtil.getLocaleMessage("gui.realmstoneMenu.hover." + id), 200));
                return texts;
            });
        }

        public String getId() {
            return this.id;
        }

        public String[] getParents() {
            return this.parentNodes;
        }

        public JsonObject toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("id", this.id);
            obj.addProperty("gui_x", (Number)this.posX);
            obj.addProperty("gui_y", (Number)this.posY);
            if (this.parentNodes.length > 0) {
                JsonArray parentNodes = new JsonArray();
                for (String str : this.parentNodes) {
                    parentNodes.add(str);
                }
                obj.add("parents", (JsonElement)parentNodes);
            }
            return obj;
        }

        public static RealmstoneWorldInsert fromJson(JsonObject jsonObject) {
            String[] parentNodes;
            if (jsonObject.has("parents")) {
                JsonArray parents = jsonObject.get("parents").getAsJsonArray();
                parentNodes = new String[parents.size()];
                int i = 0;
                for (JsonElement element : parents) {
                    parentNodes[i] = element.getAsString();
                    ++i;
                }
            } else {
                parentNodes = new String[]{};
            }
            return new RealmstoneWorldInsert(jsonObject.get("id").getAsString(), jsonObject.get("gui_x").getAsInt(), jsonObject.get("gui_y").getAsInt(), parentNodes);
        }

        private void render(PoseStack matrix, Minecraft mc, HashMap<String, RealmstoneWorldInsert> worldInserts, int baseX, int baseY, int scrollX, int scrollY, int mouseX, int mouseY) {
            int overlapBottom;
            int overlapRight;
            int overlapTop;
            int renderX = baseX + this.posX - scrollX;
            int renderY = baseY + this.posY - scrollY;
            int overlapLeft = Mth.m_14045_((int)(baseX - renderX), (int)0, (int)100);
            if (overlapLeft < 100 && (overlapTop = Mth.m_14045_((int)(baseY - renderY), (int)0, (int)100)) < 100 && (overlapRight = Mth.m_14045_((int)(renderX + 100 - (baseX + (int)(238.0f / scale))), (int)0, (int)100)) < 100 && (overlapBottom = Mth.m_14045_((int)(renderY + 100 - (baseY + (int)(166.0f / scale))), (int)0, (int)100)) < 100) {
                renderX += overlapLeft;
                renderY += overlapTop;
                int width = 100 - overlapLeft - overlapRight;
                int height = 100 - overlapTop - overlapBottom;
                GlStateManager.m_84525_();
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
                RenderUtil.renderCustomSizedTexture(matrix, renderX, renderY, overlapLeft, overlapTop, width, height, 100.0f, 100.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)widgets);
                RenderUtil.renderCustomSizedTexture(matrix, renderX, renderY, overlapLeft, overlapTop, width, height, 210.0f, 100.0f);
                GlStateManager.m_84519_();
                if (currentlyHoveredInsert == null && NumberUtil.isWithinArea(mouseX, mouseY, renderX + 5, renderY + 5, renderX + width - 5, renderY + height - 5)) {
                    currentlyHoveredInsert = this;
                }
            }
            this.renderLinks(matrix, mc, worldInserts, baseX, baseY, scrollX, scrollY);
        }

        private void renderLinks(PoseStack matrix, Minecraft mc, HashMap<String, RealmstoneWorldInsert> nodes, int baseX, int baseY, int scrollX, int scrollY) {
            rand.setSeed(0L);
            RenderSystem.m_69478_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)widgets);
            int minX = baseX - (int)(1.5f / scale);
            int minY = baseY - (int)(3.0f / scale);
            int maxX = baseX + (int)(246.5f / scale);
            int maxY = baseY + (int)(174.5f / scale);
            for (String id : this.parentNodes) {
                rand.setSeed((long)this.posX + (long)this.posY * (long)this.parentNodes.length * (long)id.length());
                RealmstoneWorldInsert parent = nodes.get(id);
                int x = baseX + parent.posX + 50 - scrollX;
                int y = baseY + parent.posY + 50 - scrollY;
                int x2 = baseX + this.posX + 50 - scrollX;
                int y2 = baseY + this.posY + 50 - scrollY;
                int distX = x - x2;
                int distY = y - y2;
                float originalWidth = (float)Math.sqrt(distX * distX + distY * distY) - 80.0f;
                int startClipVal = this.calcLineCornerCutoff(x, y, minX, minY, maxX, maxY);
                int endClipVal = this.calcLineCornerCutoff(x2, y2, minX, minY, maxX, maxY);
                boolean shouldRender = false;
                boolean trimStart = false;
                for (int i = 3; i > 0; --i) {
                    if (startClipVal + endClipVal == 0) {
                        shouldRender = true;
                        break;
                    }
                    if (startClipVal != 0 && endClipVal != 0) break;
                    double testX = x;
                    double testY = y;
                    int testVal = Math.max(endClipVal, startClipVal);
                    if (startClipVal > endClipVal) {
                        trimStart = true;
                    }
                    if ((testVal & 8) == 8) {
                        testX = (float)x + (float)((x2 - x) * (maxY - y)) / (float)(y2 - y);
                        testY = maxY;
                    } else if ((testVal & 4) == 4) {
                        testX = (float)x + (float)((x2 - x) * (baseY - y)) / (float)(y2 - y);
                        testY = baseY;
                    } else if ((testVal & 2) == 2) {
                        testX = maxX;
                        testY = (float)y + (float)((y2 - y) * (maxX - x)) / (float)(x2 - x);
                    } else if ((testVal & 1) == 1) {
                        testX = baseX;
                        testY = (float)y + (float)((y2 - y) * (baseX - x)) / (float)(x2 - x);
                    }
                    if (testVal == startClipVal) {
                        x = (int)testX;
                        y = (int)testY;
                        startClipVal = this.calcLineCornerCutoff(x, y, minX, minY, maxX, maxY);
                        continue;
                    }
                    x2 = (int)testX;
                    y2 = (int)testY;
                    endClipVal = this.calcLineCornerCutoff(x2, y2, minX, minY, maxX, maxY);
                }
                if (!shouldRender) continue;
                distX = x - x2;
                distY = y - y2;
                double angle = Math.atan2(distY, distX) + Math.PI;
                float renderWidth = (float)Math.sqrt(distX * distX + distY * distY) - 80.0f;
                float uWidth = 110.0f * (renderWidth / originalWidth);
                float u = 100.0f;
                if (uWidth < 110.0f && trimStart) {
                    u += 110.0f - uWidth;
                }
                matrix.m_85836_();
                matrix.m_252880_((float)x, (float)y, 0.0f);
                RenderSystem.m_157427_(GameRenderer::m_172820_);
                RenderSystem.m_157429_((float)rand.nextFloat(), (float)rand.nextFloat(), (float)rand.nextFloat(), (float)1.0f);
                matrix.m_252781_(Axis.f_252403_.m_252961_((float)angle));
                RenderUtil.renderScaledCustomSizedTexture(matrix, 40.0f, -7.5f, u, rand.nextInt(5) * 15, uWidth, 15.0f, renderWidth, 15.0f, 210.0f, 100.0f);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                matrix.m_85849_();
            }
            GlStateManager.m_84519_();
        }

        private ArrayList<FormattedCharSequence> getHoverTexts() {
            return (ArrayList)this.hoverTexts.get();
        }

        private int calcLineCornerCutoff(int x, int y, int minX, int minY, int maxX, int maxY) {
            int val = 0;
            if (x < minX) {
                val = 1;
            } else if (x > maxX) {
                val = 2;
            }
            if (y < minY) {
                val += 4;
            } else if (y > maxY) {
                val += 8;
            }
            return val;
        }
    }
}

