/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.eventbus.api.EventPriority;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.library.constant.ScreenImageEffect;
import net.tslat.aoa3.util.RenderUtil;
import org.joml.Matrix4f;

public final class ScreenEffectRenderer {
    private static final CopyOnWriteArrayList<ScreenImageEffect> effects = new CopyOnWriteArrayList();

    public static void init() {
        AdventOfAscension.modEventBus.addListener(EventPriority.NORMAL, false, RegisterGuiOverlaysEvent.class, ev -> ev.registerAboveAll("aoa_screen_effects", ScreenEffectRenderer::onEffectRender));
    }

    public static void addScreenEffect(ScreenImageEffect effect) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        effect.init(mc.m_91268_(), mc.f_91073_.m_46467_());
        effects.add(effect);
    }

    public static void clearOverlays() {
        effects.clear();
    }

    private static void onEffectRender(ForgeGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        if (Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.FIRST_PERSON || effects.isEmpty() || Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        long gameTime = mc.f_91073_.m_46467_();
        boolean hasExpiredEffects = false;
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        for (ScreenImageEffect effect2 : effects) {
            if (effect2.isExpired(gameTime)) {
                hasExpiredEffects = true;
                continue;
            }
            float scale = effect2.getScale();
            float fadeTime = (float)(effect2.getExpiry() - gameTime) / (float)effect2.getDuration();
            poseStack.m_85836_();
            RenderSystem.m_157429_((float)effect2.getRed(), (float)effect2.getGreen(), (float)effect2.getBlue(), (float)(effect2.getAlpha() * fadeTime));
            RenderUtil.setRenderingTexture(effect2.getTexture());
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            if (effect2.isFullscreen()) {
                buffer.m_5483_(0.0, (double)window.m_85446_(), -90.0).m_7421_(0.0f, 1.0f).m_5752_();
                buffer.m_5483_((double)window.m_85445_(), (double)window.m_85446_(), -90.0).m_7421_(1.0f, 1.0f).m_5752_();
                buffer.m_5483_((double)window.m_85445_(), 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
                buffer.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
            } else {
                poseStack.m_85841_(scale, scale, scale);
                poseStack.m_252880_(effect2.x(), effect2.y(), 0.0f);
                Matrix4f pose = poseStack.m_85850_().m_252922_();
                buffer.m_252986_(pose, 0.0f, 256.0f, -90.0f).m_7421_(0.0f, 1.0f).m_5752_();
                buffer.m_252986_(pose, 256.0f, 256.0f, -90.0f).m_7421_(1.0f, 1.0f).m_5752_();
                buffer.m_252986_(pose, 256.0f, 0.0f, -90.0f).m_7421_(1.0f, 0.0f).m_5752_();
                buffer.m_252986_(pose, 0.0f, 0.0f, -90.0f).m_7421_(0.0f, 0.0f).m_5752_();
            }
            tesselator.m_85914_();
            poseStack.m_85849_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
        if (hasExpiredEffects) {
            effects.removeIf(effect -> effect.isExpired(gameTime));
        }
    }
}

