/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.lib;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ScreenUtils;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public abstract class ScrollablePane {
    private Minecraft mc;
    protected int top;
    protected int bottom;
    protected int left;
    protected int right;
    protected int viewWidth;
    protected int viewHeight;
    protected int scrollBarHeight;
    private float currentRenderScale;
    protected int mouseX;
    protected int mouseY;
    private boolean mouseFocussed;
    protected boolean isDragging = false;
    private float mouseYPosState = -2.0f;
    protected float distanceScrolled;
    private float scrollFactor;

    public ScrollablePane(Minecraft mc, int top, int left, int viewHeight, int viewWidth, float renderingScale) {
        this.mc = mc;
        this.top = top;
        this.left = left;
        this.viewWidth = viewWidth;
        this.viewHeight = viewHeight;
        this.bottom = top + viewHeight;
        this.right = left + viewWidth;
        this.currentRenderScale = renderingScale;
    }

    public void render(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        int scrollBarWidth = 6;
        this.mouseFocussed = this.isMouseHovering();
        int paneHeight = this.getFullPaneHeight();
        int paneViewDiff = Math.max(0, paneHeight - this.viewHeight);
        if (paneViewDiff > 0) {
            this.scrollBarHeight = (int)Mth.m_14036_((float)((float)(this.viewHeight * this.viewHeight) / (float)paneHeight), (float)32.0f, (float)this.viewHeight);
        }
        if (this.isDragging) {
            if (this.mouseYPosState == -1.0f) {
                if (this.mouseFocussed) {
                    if (mouseX >= this.right - scrollBarWidth - 2 && mouseX <= this.right) {
                        this.scrollFactor = -1.0f;
                        int scrollHeight = Math.max(paneHeight - this.viewHeight, 1);
                        this.scrollFactor /= (float)(this.viewHeight - this.scrollBarHeight) / (float)scrollHeight;
                    } else {
                        this.scrollFactor = 1.0f;
                    }
                    this.mouseYPosState = mouseY;
                } else {
                    this.mouseYPosState = -2.0f;
                }
            } else if (this.mouseYPosState >= 0.0f) {
                this.distanceScrolled -= ((float)mouseY - this.mouseYPosState) * this.scrollFactor;
                this.mouseYPosState = mouseY;
            }
        } else {
            this.mouseYPosState = -1.0f;
        }
        this.distanceScrolled = Mth.m_14036_((float)this.distanceScrolled, (float)0.0f, (float)paneViewDiff);
        Window mcWindow = this.mc.m_91268_();
        float windowWidthScale = this.currentRenderScale * ((float)mcWindow.m_85443_() / (float)mcWindow.m_85445_());
        float windowHeightScale = this.currentRenderScale * ((float)mcWindow.m_85444_() / (float)mcWindow.m_85446_());
        RenderSystem.m_69488_((int)((int)(((double)this.left - 1.5) * (double)windowWidthScale)), (int)((int)(((float)mcWindow.m_85444_() / windowHeightScale - (float)this.bottom - 2.0f) * windowHeightScale)), (int)((int)((float)(this.viewWidth + 3) * windowWidthScale)), (int)((int)(((double)this.viewHeight + 1.5) * (double)windowHeightScale + 2.0)));
        this.drawBackground(matrix);
        ScreenUtils.drawGradientRect((Matrix4f)matrix.m_85850_().m_252922_(), (int)0, (int)(this.left - 1), (int)(this.top - 1), (int)(this.right + 1), (int)(this.bottom + 1), (int)-1072689136, (int)-804253680);
        int newTop = this.top - Math.max(0, (int)this.distanceScrolled);
        this.drawPaneContents(matrix, newTop, this.left, this.right, this.bottom, this.distanceScrolled, partialTicks);
        RenderSystem.m_69465_();
        if (paneViewDiff > 0) {
            int barTop = Math.max((int)this.distanceScrolled * (this.viewHeight - this.scrollBarHeight) / paneViewDiff + this.top, this.top);
            int barLeft = this.right - 6;
            Tesselator tess = Tesselator.m_85913_();
            BufferBuilder buff = tess.m_85915_();
            Matrix4f matrix4f = matrix.m_85850_().m_252922_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            buff.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buff.m_252986_(matrix4f, (float)barLeft, (float)this.bottom, 0.0f).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
            buff.m_252986_(matrix4f, (float)(this.right + 1), (float)this.bottom, 0.0f).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
            buff.m_252986_(matrix4f, (float)(this.right + 1), (float)this.top, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            buff.m_252986_(matrix4f, (float)barLeft, (float)this.top, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            tess.m_85914_();
            buff.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buff.m_252986_(matrix4f, (float)barLeft, (float)(barTop + this.scrollBarHeight), 0.0f).m_7421_(0.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
            buff.m_252986_(matrix4f, (float)(this.right + 1), (float)(barTop + this.scrollBarHeight), 0.0f).m_7421_(1.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
            buff.m_252986_(matrix4f, (float)(this.right + 1), (float)barTop, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
            buff.m_252986_(matrix4f, (float)barLeft, (float)barTop, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
            tess.m_85914_();
            buff.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buff.m_252986_(matrix4f, (float)barLeft, (float)(barTop + this.scrollBarHeight - 1), 0.0f).m_7421_(0.0f, 1.0f).m_6122_(192, 192, 192, 255).m_5752_();
            buff.m_252986_(matrix4f, (float)this.right, (float)(barTop + this.scrollBarHeight - 1), 0.0f).m_7421_(1.0f, 1.0f).m_6122_(192, 192, 192, 255).m_5752_();
            buff.m_252986_(matrix4f, (float)this.right, (float)barTop, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(192, 192, 192, 255).m_5752_();
            buff.m_252986_(matrix4f, (float)barLeft, (float)barTop, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(192, 192, 192, 255).m_5752_();
            tess.m_85914_();
        }
        RenderSystem.m_69461_();
        RenderSystem.m_69471_();
    }

    public void onResize(Minecraft mc, int left, int top, int viewWidth, int viewHeight) {
        this.mc = mc;
        this.top = top;
        this.left = left;
        this.viewHeight = viewHeight;
        this.viewWidth = viewWidth;
        this.bottom = top + viewHeight;
        this.right = left + viewWidth;
    }

    public boolean handleMouseClick(double mouseX, double mouseY, int button) {
        this.isDragging = true;
        return this.isMouseHovering();
    }

    public boolean handleMouseReleased(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        return this.isMouseHovering();
    }

    public boolean handleMouseScroll(double mouseX, double mouseY, double scrollAmount) {
        if (!this.mouseFocussed) {
            return false;
        }
        if (scrollAmount != 0.0) {
            this.distanceScrolled = (float)((double)this.distanceScrolled + -20.0 * scrollAmount);
        }
        return this.isMouseHovering();
    }

    protected boolean isMouseHovering() {
        return this.mouseX >= this.left && this.mouseX <= this.right && this.mouseY >= this.top && this.mouseY <= this.bottom;
    }

    public abstract int getFullPaneHeight();

    public abstract void drawPaneContents(PoseStack var1, int var2, int var3, int var4, int var5, float var6, float var7);

    public abstract void drawBackground(PoseStack var1);
}

