/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.hud;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.util.Mth;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.EventPriority;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.render.AoAGuiElementRenderers;
import net.tslat.aoa3.client.render.custom.AoASkillRenderer;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.ClientPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.HolidayUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public final class XpParticlesRenderer {
    private static final ConcurrentHashMap<AoASkill, CopyOnWriteArrayList<XPParticle>> particlesMap = new ConcurrentHashMap(15);
    private static long lastPacketReceivedTime = 0L;
    private static XPParticle lastParticleReceived = null;
    private static AoASkill lastParticleSkill = null;

    public static void init() {
        AdventOfAscension.modEventBus.addListener(EventPriority.NORMAL, false, RegisterGuiOverlaysEvent.class, ev -> ev.registerAbove(VanillaGuiOverlay.POTION_ICONS.id(), "aoa_xp_particles", XpParticlesRenderer::renderParticles));
    }

    public static void addXpParticle(AoASkill skill, float xp, boolean isLevelUp) {
        XPParticle particle;
        if (!particlesMap.containsKey(skill)) {
            particlesMap.put(skill, new CopyOnWriteArrayList());
        }
        if (lastParticleSkill == skill && lastParticleReceived != null && System.currentTimeMillis() <= lastPacketReceivedTime + 10L) {
            lastParticleReceived.modifyXp(xp, isLevelUp);
            if (XpParticlesRenderer.lastParticleReceived.levelUp) {
                CopyOnWriteArrayList<XPParticle> array = particlesMap.get(skill);
                if (array.size() > 0) {
                    array.remove(array.size() - 1);
                }
                array.add(0, lastParticleReceived);
            }
            return;
        }
        if (isLevelUp) {
            particle = new XPParticle(xp, true);
            particlesMap.get(skill).add(0, particle);
        } else {
            particle = new XPParticle(xp, false);
            particlesMap.get(skill).add(particle);
        }
        lastParticleReceived = particle;
        lastParticleSkill = skill;
        lastPacketReceivedTime = System.currentTimeMillis();
    }

    private static void purgeExpiredEntries() {
        if (!((Boolean)AoAConfigs.CLIENT.showXpParticles.get()).booleanValue()) {
            particlesMap.clear();
            return;
        }
        Iterator<Map.Entry<AoASkill, CopyOnWriteArrayList<XPParticle>>> particleEntries = particlesMap.entrySet().iterator();
        long currentTime = System.currentTimeMillis();
        long expiryTime = currentTime - 1800L;
        while (particleEntries.hasNext()) {
            Map.Entry<AoASkill, CopyOnWriteArrayList<XPParticle>> entry = particleEntries.next();
            entry.getValue().removeIf(particle -> particle.creationTime <= expiryTime);
            if (!entry.getValue().isEmpty()) continue;
            particleEntries.remove();
        }
    }

    private static void renderParticles(ForgeGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        if (particlesMap.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        float scrollHeight = (float)window.m_85446_() / 3.0f;
        int windowWidth = window.m_85445_();
        int maxHeight = 0;
        int cumulativeXOffset = 0;
        int x = 0;
        int y = 0;
        boolean hasExpiredParticles = false;
        poseStack.m_85836_();
        poseStack.m_252880_((float)windowWidth / 2.0f, 1.0f, 0.0f);
        if (particlesMap.size() > 2) {
            poseStack.m_252880_((float)Math.min(particlesMap.size(), 5) / 2.0f * 12.0f + 12.0f, 0.0f, 0.0f);
        }
        RenderSystem.m_69465_();
        for (Map.Entry<AoASkill, CopyOnWriteArrayList<XPParticle>> entry : particlesMap.entrySet()) {
            AoASkill.Instance skill = ClientPlayerDataManager.get().getSkill(entry.getKey());
            if (skill == AoASkills.DEFAULT) continue;
            CopyOnWriteArrayList<XPParticle> particles = entry.getValue();
            AoASkillRenderer skillRenderer = AoAGuiElementRenderers.getSkillRenderer(skill.type());
            int renderWidth = skillRenderer.hudRenderWidth(skill);
            int renderHeight = skillRenderer.hudRenderHeight(skill);
            poseStack.m_85836_();
            poseStack.m_252880_((float)x, (float)y, 0.0f);
            poseStack.m_85836_();
            poseStack.m_85837_((double)renderWidth / 2.0, 0.0, 0.0);
            for (XPParticle particle : particles) {
                if (particle.creationTime <= currentTime - 1800L) {
                    hasExpiredParticles = true;
                    continue;
                }
                float lifespan = 1.0f - (float)(currentTime - particle.creationTime) / 1500.0f;
                if (!(lifespan >= 0.1f)) continue;
                RenderUtil.drawCenteredScaledString(poseStack, mc.f_91062_, particle.xpString, 0.0f, scrollHeight * lifespan, 0.5f, ColourUtil.RGBA(255, 255, 255, (int)Mth.m_14036_((float)(255.0f * lifespan), (float)1.0f, (float)255.0f)), RenderUtil.StringRenderType.NORMAL);
            }
            poseStack.m_85849_();
            skillRenderer.renderInHud(poseStack, skill, partialTick, AoASkillRenderer.ProgressRenderType.Ring, false);
            if (particles.get((int)0).levelUp) {
                String level = String.valueOf(skill.getLevel(true));
                float stringWidth = mc.f_91062_.m_92895_(level);
                float f = 1.0f / (stringWidth / (float)(renderWidth - 7));
                Objects.requireNonNull(mc.f_91062_);
                float scale = Math.min(f, 1.0f / (9.0f / (float)(renderHeight - 7)));
                poseStack.m_85837_((double)renderWidth / 2.0, (double)renderHeight / 2.0, 0.0);
                Font font = mc.f_91062_;
                Objects.requireNonNull(mc.f_91062_);
                RenderUtil.drawCenteredScaledString(poseStack, font, level, scale * 0.5f, (float)(-9) * scale / 2.5f, scale, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
            }
            x -= renderWidth;
            maxHeight = Math.max(maxHeight, renderHeight);
            if ((cumulativeXOffset += renderWidth) >= 100) {
                y += maxHeight;
                x = 0;
                maxHeight = 0;
                cumulativeXOffset = 0;
            }
            poseStack.m_85849_();
        }
        RenderSystem.m_69482_();
        poseStack.m_85849_();
        if (hasExpiredParticles) {
            XpParticlesRenderer.purgeExpiredEntries();
        }
    }

    private static String getAprilFoolsXpString() {
        return (String)RandomUtil.getRandomSelection((Object[])new String[]{"Nice!", "69xp", "420xp", "-1xp", "422180734982xp", "Xp Get!", "GAINSSS", "5xp maybe?", "\u2308(\u23081*50^1.3\u2309/8+800)/46*37\u2309+6xp", "?", "Where am I?", "Weeeeeee!", "Going up!", "I'm sad", "Goodbye!"});
    }

    static class XPParticle {
        boolean levelUp;
        float xp;
        String xpString;
        protected long creationTime = System.currentTimeMillis();

        XPParticle(float xp, boolean isLevelUp) {
            this.levelUp = isLevelUp;
            this.xp = xp;
            this.xpString = HolidayUtil.isAprilFools() ? XpParticlesRenderer.getAprilFoolsXpString() : "+" + NumberUtil.floorAndAppendSuffix(xp, false);
        }

        protected void modifyXp(float additionalXp, boolean isLevelUp) {
            this.levelUp = this.levelUp || isLevelUp;
            this.xp += additionalXp;
            this.xpString = HolidayUtil.isAprilFools() ? XpParticlesRenderer.getAprilFoolsXpString() : "+" + NumberUtil.floorAndAppendSuffix(this.xp, false);
        }
    }
}

