/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.hud;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.RegistryUtil;
import net.tslat.aoa3.util.RenderUtil;

public final class BossBarRenderer {
    public static final int STANDARD_BAR_WIDTH = 196;
    private static final Map<ResourceLocation, ResourceLocation> BAR_ID_CACHE = new Object2ObjectOpenHashMap();

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, CustomizeGuiOverlayEvent.BossEventProgress.class, BossBarRenderer::onBossInfoRender);
    }

    private static void onBossInfoRender(CustomizeGuiOverlayEvent.BossEventProgress ev) {
        if (ev.isCanceled() || Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        LerpingBossEvent bossStatusInfo = ev.getBossEvent();
        if (bossStatusInfo.m_18862_() != BossEvent.BossBarColor.GREEN || bossStatusInfo.m_18863_() != BossEvent.BossBarOverlay.NOTCHED_20) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Entity entity = (Entity)mc.f_91073_.m_142646_().m_142694_(bossStatusInfo.m_18860_());
        if (entity == null) {
            return;
        }
        RenderUtil.resetShaderColour();
        RenderUtil.prepRenderTexture(BAR_ID_CACHE.computeIfAbsent(RegistryUtil.getId(entity.m_6095_()), key -> new ResourceLocation(key.m_135827_(), "textures/gui/bossbars/" + key.m_135815_() + ".png")));
        Window window = mc.m_91268_();
        PoseStack poseStack = ev.getPoseStack();
        int xPos = window.m_85445_() / 2 - 100;
        int yPos = ev.getY();
        float progressWidth = bossStatusInfo.m_142717_() * 196.0f;
        Component displayName = bossStatusInfo.m_18861_();
        if (progressWidth < 196.0f) {
            RenderUtil.renderCustomSizedTexture(poseStack, xPos, yPos, 0.0f, 12.0f, 200.0f, 12.0f, 200.0f, 36.0f);
        }
        if (progressWidth > 0.0f) {
            RenderUtil.renderCustomSizedTexture(poseStack, xPos + 2, yPos, 2.0f, 0.0f, progressWidth, 12.0f, 200.0f, 36.0f);
        }
        RenderUtil.renderCustomSizedTexture(poseStack, xPos, yPos, 0.0f, 24.0f, 200.0f, 12.0f, 200.0f, 36.0f);
        mc.f_91062_.m_92763_(poseStack, displayName, (float)(window.m_85445_() / 2 - mc.f_91062_.m_92852_((FormattedText)displayName) / 2), (float)(yPos - 9), ColourUtil.WHITE);
        ev.setIncrement(ev.getIncrement() + 5);
        ev.setCanceled(true);
    }
}

