/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.container;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.common.container.FrameBenchContainer;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.GuiDataPacket;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RenderUtil;

public class FrameBenchScreen
extends AbstractContainerScreen<FrameBenchContainer> {
    private static final ResourceLocation textures = new ResourceLocation("aoa3", "textures/gui/containers/frame_bench.png");
    private static FrameBenchScreen instance = null;
    private static String currentSelection = "helmet";

    public FrameBenchScreen(FrameBenchContainer container, Inventory inv, Component guiTitle) {
        super((AbstractContainerMenu)container, inv, guiTitle);
        currentSelection = "helmet";
        instance = this;
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new FrameSelectButton(this.f_97735_ + 45, this.f_97736_ + 33, "helmet", (Item)AoAItems.HELMET_FRAME.get()));
        this.m_142416_((GuiEventListener)new FrameSelectButton(this.f_97735_ + 65, this.f_97736_ + 33, "chestplate", (Item)AoAItems.CHESTPLATE_FRAME.get()));
        this.m_142416_((GuiEventListener)new FrameSelectButton(this.f_97735_ + 85, this.f_97736_ + 33, "leggings", (Item)AoAItems.LEGGINGS_FRAME.get()));
        this.m_142416_((GuiEventListener)new FrameSelectButton(this.f_97735_ + 105, this.f_97736_ + 33, "boots", (Item)AoAItems.BOOTS_FRAME.get()));
        this.m_142416_((GuiEventListener)new FrameSelectButton(this.f_97735_ + 55, this.f_97736_ + 13, "crossbow", (Item)AoAItems.CROSSBOW_FRAME.get()));
        this.m_142416_((GuiEventListener)new FrameSelectButton(this.f_97735_ + 75, this.f_97736_ + 13, "blaster", (Item)AoAItems.BLASTER_FRAME.get()));
        this.m_142416_((GuiEventListener)new FrameSelectButton(this.f_97735_ + 95, this.f_97736_ + 13, "cannon", (Item)AoAItems.CANNON_FRAME.get()));
        this.m_142416_((GuiEventListener)new FrameSelectButton(this.f_97735_ + 55, this.f_97736_ + 53, "gun", (Item)AoAItems.GUN_FRAME.get()));
        this.m_142416_((GuiEventListener)new FrameSelectButton(this.f_97735_ + 75, this.f_97736_ + 53, "shotgun", (Item)AoAItems.SHOTGUN_FRAME.get()));
        this.m_142416_((GuiEventListener)new FrameSelectButton(this.f_97735_ + 95, this.f_97736_ + 53, "sniper", (Item)AoAItems.SNIPER_FRAME.get()));
    }

    public void m_86412_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrix);
        super.m_86412_(matrix, mouseX, mouseY, partialTicks);
        this.m_7025_(matrix, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderUtil.resetShaderColour();
        RenderUtil.prepRenderTexture(textures);
        RenderUtil.renderCustomSizedTexture(matrix, this.f_97735_, this.f_97736_, 0.0f, 0.0f, 175.0f, 165.0f, 256.0f, 256.0f);
    }

    private static class FrameSelectButton
    extends Button {
        private static final int buttonWidth = 18;
        private static final int buttonHeight = 18;
        private final String selectionValue;
        private final Item frame;

        private FrameSelectButton(int x, int y, String selectionValue, Item frame) {
            super(x, y, 18, 18, (Component)Component.m_237115_((String)frame.m_5524_()), button -> {}, f_252438_);
            this.selectionValue = selectionValue;
            this.frame = frame;
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)LocaleUtil.getItemName((ItemLike)this.frame))));
        }

        public void m_87963_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            Minecraft mc = Minecraft.m_91087_();
            poseStack.m_85836_();
            RenderUtil.prepRenderTexture(textures);
            RenderUtil.resetShaderColour();
            this.f_93622_ = this.isMouseInRegion(mouseX, mouseY, this.m_252754_(), this.m_252907_());
            int textureX = 176;
            int textureY = 21 + 18 * (this.selectionValue.equals(currentSelection) ? 0 : RenderUtil.selectVForWidgetState((AbstractWidget)this, 1, 1, 2));
            RenderUtil.renderCustomSizedTexture(poseStack, this.m_252754_(), this.m_252907_(), textureX, textureY, 18.0f, 18.0f, 256.0f, 256.0f);
            poseStack.m_252880_(0.0f, 0.0f, 32.0f);
            mc.m_91291_().m_274569_(poseStack, new ItemStack((ItemLike)this.frame), this.m_252754_() + 1, this.m_252907_() + 1);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= buttonX && mouseX <= buttonX + 18 && mouseY >= buttonY && mouseY <= buttonY + 18;
        }

        protected boolean m_93680_(double p_clicked_1_, double p_clicked_3_) {
            return this.f_93623_ && this.f_93622_ && !this.selectionValue.equals(currentSelection);
        }

        public void m_5716_(double p_onClick_1_, double p_onClick_3_) {
            currentSelection = this.selectionValue;
            AoAPackets.messageServer(new GuiDataPacket(GuiDataPacket.Type.FRAME_BENCH_SELECTION, currentSelection));
            ((FrameBenchContainer)((FrameBenchScreen)Minecraft.m_91087_().f_91080_).m_6262_()).changeSelection(currentSelection);
        }
    }
}

