/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.adventgui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.achievement.StatsUpdateListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabBestiary;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabHelp;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabPlayer;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.data.client.AdventGuiThemeReloadListener;
import net.tslat.aoa3.integration.IntegrationManager;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.HolidayUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.aoa3.util.WebUtil;

public class AdventMainGui
extends Screen
implements StatsUpdateListener {
    private static final ResourceLocation TITLE = HolidayUtil.isAprilFools() ? new ResourceLocation("aoa3", "textures/gui/adventgui/aoa_title_alt.png") : new ResourceLocation("aoa3", "textures/gui/adventgui/aoa_title.png");
    protected static final int GUI_WIDTH = 1024;
    protected static final int GUI_HEIGHT = 512;
    protected static final int BACKGROUND_TEXTURE_WIDTH = 976;
    protected static final int BACKGROUND_TEXTURE_HEIGHT = 480;
    protected static final float SCALE = 0.45f;
    protected static AdventMainGui instance;
    protected static AdventGuiThemeReloadListener.AdventGuiTheme theme;
    private static ADVENT_WINDOW_TAB selectedTab;
    @Nullable
    private static Screen tabScreen;
    protected Player player;
    protected static int scaledRootX;
    protected static int scaledRootY;
    protected static int scaledTabRootX;
    protected static int scaledTabRootY;
    private static int updateMessageTicker;

    public AdventMainGui(Player player) {
        super((Component)Component.m_237115_((String)"gui.aoa3.adventGui.title"));
        this.player = player;
        instance = this;
        tabScreen = null;
    }

    protected void m_7856_() {
        theme = AdventGuiThemeReloadListener.setTheme((String)AoAConfigs.CLIENT.adventGuiTheme.get());
        this.m_142416_((GuiEventListener)new AdventMainGuiTabButton(11, 129, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.stats"), ADVENT_WINDOW_TAB.PLAYER));
        this.m_142416_((GuiEventListener)new AdventMainGuiTabButton(11, 199, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.bestiary"), ADVENT_WINDOW_TAB.BESTIARY));
        this.m_142416_((GuiEventListener)new AdventMainGuiTabButton(11, 339, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.leaderboards"), ADVENT_WINDOW_TAB.LEADERBOARDS));
        this.m_142416_((GuiEventListener)new AdventMainGuiTabButton(11, 409, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help"), ADVENT_WINDOW_TAB.HELP));
        this.correctGuiPositions();
        this.initTabScreen();
    }

    public void m_86412_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrix);
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)theme.backgroundTexture());
        matrix.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrix.m_85841_(0.45f, 0.45f, 0.45f);
        RenderUtil.renderCustomSizedTexture(matrix, scaledRootX, scaledRootY, 24.0f, 16.0f, 976.0f, 480.0f, 1024.0f, 512.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TITLE);
        RenderUtil.renderCustomSizedTexture(matrix, scaledRootX - 24 + 68, scaledRootY - 16 + 21, 0.0f, 0.0f, 892.0f, 112.0f, 892.0f, 112.0f);
        super.m_86412_(matrix, mouseX, mouseY, partialTicks);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (theme.overlayTexture() != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)theme.overlayTexture());
            RenderSystem.m_69478_();
            RenderUtil.renderCustomSizedTexture(matrix, scaledRootX - 24, scaledRootY - 16, 0.0f, 0.0f, 1024.0f, 512.0f, 1024.0f, 512.0f);
            RenderSystem.m_69461_();
        }
        RenderUtil.drawScaledMessage(matrix, this.f_96547_, (Component)Component.m_237113_((String)"v1.19.4-3.6.25"), scaledRootX + 175, scaledRootY + 85, 1.25f, ColourUtil.RGB(255, 223, 0), RenderUtil.StringRenderType.DROP_SHADOW);
        if (WebUtil.isUpdateAvailable()) {
            if (--updateMessageTicker <= -30) {
                updateMessageTicker = 90;
            }
            if (updateMessageTicker > 0) {
                MutableComponent msg = LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.update", new Component[]{Component.m_237113_((String)WebUtil.getLatestVersion())});
                RenderUtil.drawScaledMessage(matrix, this.f_96547_, (Component)msg, scaledRootX + 915 - this.f_96547_.m_92852_((FormattedText)msg), scaledRootY + 105, 1.25f, ColourUtil.RGB(229, 0, 0), RenderUtil.StringRenderType.DROP_SHADOW);
            }
        }
        if (tabScreen != null) {
            tabScreen.m_86412_(matrix, mouseX, mouseY, partialTicks);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrix.m_85849_();
    }

    public static boolean isBlockingKeys() {
        if (tabScreen instanceof AdventGuiTabBestiary) {
            EditBox bestiarySearchField = ((AdventGuiTabBestiary)AdventMainGui.tabScreen).searchField;
            return bestiarySearchField != null && bestiarySearchField.m_93696_();
        }
        return false;
    }

    public void m_7819_() {
        if (tabScreen instanceof StatsUpdateListener) {
            ((StatsUpdateListener)tabScreen).m_7819_();
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollAmount) {
        if (tabScreen != null) {
            return tabScreen.m_6050_(mouseX, mouseY, scrollAmount);
        }
        return super.m_6050_(mouseX, mouseY, scrollAmount);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (tabScreen != null && tabScreen.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (tabScreen != null && tabScreen.m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (tabScreen != null && tabScreen.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!AdventMainGui.isBlockingKeys() && keyCode == AoAKeybinds.ADVENT_GUI.getKey().m_84873_()) {
            this.getMinecraft().m_91152_(null);
            return true;
        }
        boolean used = false;
        if (tabScreen != null) {
            used = tabScreen.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers) || used;
    }

    public boolean m_5534_(char character, int arg) {
        if (tabScreen != null) {
            return tabScreen.m_5534_(character, arg);
        }
        return super.m_5534_(character, arg);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (!super.m_7920_(keyCode, scanCode, modifiers)) {
            if (tabScreen != null) {
                return tabScreen.m_7920_(keyCode, scanCode, modifiers);
            }
            return false;
        }
        return true;
    }

    private void initTabScreen() {
        Minecraft mc = this.getMinecraft();
        int tabWidth = (int)((float)(this.f_96543_ + 182) * 0.45f);
        int tabHeight = (int)((float)(this.f_96544_ + 118) * 0.45f);
        if (tabScreen != null) {
            tabScreen.m_6575_(mc, tabWidth, tabHeight);
        } else {
            switch (selectedTab) {
                case PLAYER: {
                    tabScreen = new AdventGuiTabPlayer();
                    break;
                }
                case HELP: {
                    tabScreen = new AdventGuiTabHelp();
                    break;
                }
                case BESTIARY: {
                    tabScreen = new AdventGuiTabBestiary();
                    break;
                }
                case LORE: {
                    break;
                }
            }
            if (tabScreen != null) {
                tabScreen.m_6575_(mc, tabWidth, tabHeight);
                tabScreen.m_6574_(mc, tabWidth, tabHeight);
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private void correctGuiPositions() {
        Window window = this.getMinecraft().m_91268_();
        scaledRootX = (int)(Math.round((double)window.m_85445_() / 2.0 / (double)0.45f) - Math.round(488.0));
        scaledRootY = (int)(Math.round((double)window.m_85446_() / 2.0 / (double)0.45f) - Math.round(240.0));
        scaledTabRootX = scaledRootX + 201;
        scaledTabRootY = scaledRootY + 129;
    }

    public void m_6574_(Minecraft mc, int width, int height) {
        super.m_6574_(mc, width, height);
        this.correctGuiPositions();
        if (tabScreen != null) {
            tabScreen.m_6574_(mc, (int)((float)(width + 182) * 0.45f), (int)((float)(height + 118) * 0.45f));
        }
    }

    public void m_7861_() {
        super.m_7861_();
        if (tabScreen != null) {
            tabScreen.m_7861_();
        }
    }

    public static void changeTheme() {
        theme = AdventGuiThemeReloadListener.getNextTheme();
        AoAConfigs.CLIENT.changeAdventGuiTheme(theme.name());
    }

    static {
        theme = null;
        selectedTab = ADVENT_WINDOW_TAB.PLAYER;
        updateMessageTicker = 0;
    }

    private static class AdventMainGuiTabButton
    extends Button {
        private static final int buttonWidth = 180;
        private static final int buttonHeight = 60;
        private final ADVENT_WINDOW_TAB tabID;

        private AdventMainGuiTabButton(int x, int y, Component buttonText, ADVENT_WINDOW_TAB tab) {
            super(x, y, 180, 60, buttonText, button -> {}, f_252438_);
            this.tabID = tab;
            if (tab == ADVENT_WINDOW_TAB.LEADERBOARDS) {
                this.f_93623_ = false;
            } else if (tab == ADVENT_WINDOW_TAB.LORE && !IntegrationManager.isPatchouliActive()) {
                this.f_93623_ = false;
            }
        }

        public void m_87963_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                Minecraft mc = Minecraft.m_91087_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)theme.menuButtonTexture());
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.f_93622_ = this.isMouseInRegion(mouseX, mouseY, this.m_252754_(), this.m_252907_());
                boolean textureX = false;
                int textureY = 60 * (this.tabID == selectedTab ? 0 : RenderUtil.selectVForWidgetState((AbstractWidget)this, 2, 0, 1));
                RenderUtil.renderScaledCustomSizedTexture(matrix, scaledRootX + this.m_252754_(), scaledRootY + this.m_252907_(), (float)textureX, textureY, 180.0f, 60.0f, 180.0f, 60.0f, 180.0f, 180.0f);
                int stringColour = ColourUtil.RGB(239, 137, 119);
                if (this.getFGColor() != 0) {
                    stringColour = this.getFGColor();
                } else if (!this.f_93623_) {
                    stringColour = 0xA0A0A0;
                } else if (this.f_93622_ || this.tabID == selectedTab) {
                    stringColour = ColourUtil.RGB(247, 239, 0);
                }
                RenderUtil.drawCenteredScaledMessage(matrix, mc.f_91062_, this.m_6035_(), scaledRootX + this.m_252754_() + 90, scaledRootY + this.m_252907_() + 25, 2.0f, stringColour, RenderUtil.StringRenderType.OUTLINED);
                matrix.m_85836_();
                matrix.m_85841_(2.0f, 2.0f, 2.0f);
                if (this.f_93622_) {
                    if (!this.f_93623_ && this.tabID == ADVENT_WINDOW_TAB.LORE) {
                        this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.aoa3.adventGui.lore.patchouli")));
                    } else {
                        this.m_257544_(null);
                    }
                }
                matrix.m_85849_();
            }
        }

        protected boolean m_93680_(double mouseX, double mouseY) {
            return this.f_93623_ && this.f_93622_ && selectedTab != this.tabID;
        }

        public void m_5716_(double mouseX, double mouseY) {
            selectedTab = this.tabID;
            tabScreen = null;
            instance.initTabScreen();
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= (int)((float)(scaledRootX + buttonX) * 0.45f) && mouseX <= (int)((float)(scaledRootX + buttonX + 180) * 0.45f) && mouseY >= (int)((float)(scaledRootY + buttonY) * 0.45f) && mouseY <= (int)((float)(scaledRootY + buttonY + 60) * 0.45f);
        }
    }

    protected static enum ADVENT_WINDOW_TAB {
        PLAYER,
        BESTIARY,
        LORE,
        LEADERBOARDS,
        HELP;

    }
}

