/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.adventgui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.client.gui.adventgui.AdventMainGui;
import net.tslat.aoa3.client.gui.lib.ScrollablePane;
import net.tslat.aoa3.client.render.AoAGuiElementRenderers;
import net.tslat.aoa3.client.render.custom.AoASkillRenderer;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.AddSkillCyclePacket;
import net.tslat.aoa3.common.packet.packets.ToggleAoAAbilityPacket;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.entity.AoAAnimals;
import net.tslat.aoa3.common.registration.entity.AoAMobs;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ClientPlayerDataManager;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.joml.Vector3f;

public class AdventGuiTabPlayer
extends Screen {
    private static final ResourceLocation TOTAL_LEVEL_ICON = new ResourceLocation("aoa3", "textures/gui/aoaskill/total_level.png");
    private LivingEntity entityToRender = null;
    private float skillRenderScale = 1.0f;
    private AbilityPane abilityPane = null;
    private int adjustedMouseX;
    private int adjustedMouseY;
    private boolean hoveringSkillClose = false;
    private boolean hoveringAddCycle = false;
    private long addCycleLastClicked = -1L;

    protected AdventGuiTabPlayer() {
        super((Component)Component.m_237115_((String)"gui.aoa3.adventGui.stats"));
    }

    protected void m_7856_() {
        boolean scaled;
        this.setRenderEntity();
        block0: do {
            int totalWidth = 40;
            int totalHeight = 0;
            scaled = true;
            this.m_169413_();
            for (AoASkill.Instance skill : ClientPlayerDataManager.get().getSkills()) {
                AoASkillRenderer renderer = AoAGuiElementRenderers.getSkillRenderer(skill.type());
                float renderWidth = (float)(renderer.hudRenderWidth(skill) + 15) * this.skillRenderScale;
                float renderHeight = (float)(renderer.hudRenderHeight(skill) + 20) * this.skillRenderScale;
                if ((float)totalWidth + renderWidth >= 244.0f / this.skillRenderScale || (float)totalHeight + renderHeight >= 100.0f / this.skillRenderScale) {
                    totalWidth = 40;
                    if ((totalHeight = (int)((float)totalHeight + renderHeight)) >= 100) {
                        this.skillRenderScale *= 0.95f;
                        scaled = false;
                        continue block0;
                    }
                }
                this.m_142416_((GuiEventListener)new SkillEntry(this, totalWidth + 7, totalHeight + 10, renderer, skill, this.skillRenderScale));
                totalWidth = (int)((float)totalWidth + renderWidth);
            }
        } while (!scaled);
        AoASkill.Instance skill = this.abilityPane == null ? null : this.abilityPane.skill;
        this.abilityPane = new AbilityPane(this.f_96541_, AdventMainGui.scaledTabRootY + 50, AdventMainGui.scaledTabRootX + 250, 280, 500, 0.45f);
        this.abilityPane.setSkill(skill);
    }

    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.adjustedMouseX = (int)((float)mouseX * 2.2222223f);
        this.adjustedMouseY = (int)((float)mouseY * 2.2222223f);
        poseStack.m_85836_();
        poseStack.m_252880_((float)AdventMainGui.scaledTabRootX, (float)AdventMainGui.scaledTabRootY, 0.0f);
        if (this.abilityPane != null && this.abilityPane.skill != null) {
            AoASkillRenderer skillRenderer = AoAGuiElementRenderers.getSkillRenderer(this.abilityPane.skill.type());
            Font font = Minecraft.m_91087_().f_91062_;
            float skillRenderWidth = (float)(skillRenderer.guiRenderWidth(this.abilityPane.skill) * 3) / 2.0f;
            this.hoveringSkillClose = this.adjustedMouseX > AdventMainGui.scaledTabRootX + 736 && this.adjustedMouseX < AdventMainGui.scaledTabRootX + 755 && this.adjustedMouseY > AdventMainGui.scaledTabRootY + 7 && this.adjustedMouseY < AdventMainGui.scaledTabRootY + 27;
            poseStack.m_85836_();
            RenderUtil.drawScaledString(poseStack, font, "x", 740, 5, 3.0f, this.hoveringSkillClose ? ColourUtil.RGB(20, 20, 20) : ColourUtil.BLACK, RenderUtil.StringRenderType.OUTLINED);
            poseStack.m_252880_(150.0f - skillRenderWidth / 2.0f, 20.0f, 0.0f);
            RenderUtil.drawCenteredScaledMessage(poseStack, font, (Component)this.abilityPane.skill.getName(), 0.0f, 0.0f, 2.0f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
            poseStack.m_252880_(0.0f, 20.0f, 0.0f);
            poseStack.m_85836_();
            poseStack.m_252880_(-skillRenderWidth, 0.0f, 0.0f);
            poseStack.m_85841_(3.0f, 3.0f, 1.0f);
            skillRenderer.renderInGui(poseStack, this.abilityPane.skill, partialTicks, this.adjustedMouseX, this.adjustedMouseY, AoASkillRenderer.ProgressRenderType.None, false);
            poseStack.m_85849_();
            RenderUtil.drawCenteredScaledMessage(poseStack, font, (Component)Component.m_237110_((String)"gui.aoa3.adventGui.player.skillLevel", (Object[])new Object[]{""}), 0.0f, 80.0f, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(poseStack, font, String.valueOf(this.abilityPane.skill.getLevel(true)), 0.0f, 95.0f, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledMessage(poseStack, font, (Component)Component.m_237110_((String)"gui.aoa3.adventGui.player.skillXp", (Object[])new Object[]{""}), 0.0f, 120.0f, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(poseStack, font, NumberUtil.roundToNthDecimalPlace(this.abilityPane.skill.getXp(), 2), 0.0f, 135.0f, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledMessage(poseStack, font, (Component)Component.m_237110_((String)"gui.aoa3.adventGui.player.skillXpRemaining", (Object[])new Object[]{""}), 0.0f, 160.0f, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(poseStack, font, NumberUtil.roundToNthDecimalPlace(PlayerUtil.getXpRequiredForNextLevel(this.abilityPane.skill.getLevel(true)) - this.abilityPane.skill.getXp(), 2), 0.0f, 175.0f, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledMessage(poseStack, font, (Component)Component.m_237110_((String)"gui.aoa3.adventGui.player.skillProgress", (Object[])new Object[]{""}), 0.0f, 200.0f, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(poseStack, font, PlayerUtil.getLevelProgressPercentage(this.abilityPane.skill.getLevel(true), this.abilityPane.skill.getXp()) + "%", 0.0f, 215.0f, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledMessage(poseStack, font, (Component)Component.m_237110_((String)"gui.aoa3.adventGui.player.skillCycles", (Object[])new Object[]{""}), 0.0f, 240.0f, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
            RenderUtil.drawCenteredScaledString(poseStack, font, String.valueOf(this.abilityPane.skill.getCycles()), 0.0f, 255.0f, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
            if (this.abilityPane.skill.getLevel(true) >= 100 && this.abilityPane.skill.getCycles() < 10) {
                MutableComponent text = this.addCycleLastClicked > 0L ? Component.m_237115_((String)"gui.aoa3.adventGui.player.addCycle.confirm") : Component.m_237115_((String)"gui.aoa3.adventGui.player.addCycle");
                int buttonWidth = font.m_92852_((FormattedText)text);
                boolean bl = this.hoveringAddCycle = (float)this.adjustedMouseX > (float)AdventMainGui.scaledTabRootX + (150.0f - skillRenderWidth / 2.0f) - (float)buttonWidth / 2.0f * 1.5f && (float)this.adjustedMouseX < (float)AdventMainGui.scaledTabRootX + (150.0f - skillRenderWidth / 2.0f) + (float)buttonWidth / 2.0f * 1.5f && this.adjustedMouseY > AdventMainGui.scaledTabRootY + 315 && this.adjustedMouseY < AdventMainGui.scaledTabRootY + 327;
                if (System.currentTimeMillis() - this.addCycleLastClicked > 3000L) {
                    this.addCycleLastClicked = -1L;
                }
                RenderUtil.drawCenteredScaledMessage(poseStack, font, (Component)text, 0.0f, 275.0f, 1.5f, this.hoveringAddCycle ? ColourUtil.RGB(255, 100, 100) : ColourUtil.RGB(255, 50, 50), RenderUtil.StringRenderType.DROP_SHADOW);
            } else {
                this.hoveringAddCycle = false;
            }
            poseStack.m_85849_();
            RenderUtil.drawCenteredScaledMessage(poseStack, font, (Component)Component.m_237115_((String)"gui.aoa3.adventGui.player.abilities"), 500.0f, 20.0f, 2.0f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
            poseStack.m_85849_();
            if (this.abilityPane != null) {
                this.abilityPane.render(poseStack, this.adjustedMouseX, this.adjustedMouseY, partialTicks);
            }
            return;
        }
        this.hoveringAddCycle = false;
        this.hoveringSkillClose = false;
        poseStack.m_85841_(1.6f, 1.6f, 1.0f);
        poseStack.m_85836_();
        poseStack.m_85841_(this.skillRenderScale, this.skillRenderScale, 1.0f);
        super.m_86412_(poseStack, this.adjustedMouseX, this.adjustedMouseY, partialTicks);
        poseStack.m_85849_();
        this.drawPlayerBox(poseStack, this.adjustedMouseX, this.adjustedMouseY, 67, partialTicks);
        this.drawTotalLevel(poseStack, this.adjustedMouseX, this.adjustedMouseY, partialTicks);
        poseStack.m_85849_();
    }

    private void drawTotalLevel(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        int totalLevel = ClientPlayerDataManager.get().getTotalLevel();
        if (totalLevel == 0) {
            RenderUtil.drawCenteredScaledMessage(matrix, mc.f_91062_, (Component)Component.m_237115_((String)"gui.aoa3.adventGui.player.noSkills"), 280.0f, 80.0f, 1.5f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TOTAL_LEVEL_ICON);
        RenderUtil.renderScaledCustomSizedTexture(matrix, 10.0f, 14.0f, 0.0f, 0.0f, 48.0f, 48.0f, 60.0f, 60.0f, 48.0f, 48.0f);
        RenderUtil.drawCenteredScaledMessage(matrix, mc.f_91062_, (Component)Component.m_237115_((String)"gui.aoa3.adventGui.player.totalLevel"), 40.0f, 10.0f, 1.0f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
        RenderUtil.drawCenteredScaledString(matrix, mc.f_91062_, String.valueOf(ClientPlayerDataManager.get().getTotalLevel()), 40.0f, 40.0f, 1.0f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
    }

    private void drawPlayerBox(PoseStack poseStack, int mouseX, int mouseY, int scale, float partialTicks) {
        poseStack.m_85836_();
        if (this.entityToRender == null) {
            this.setRenderEntity();
        }
        Minecraft mc = Minecraft.m_91087_();
        Component name = mc.f_91074_.m_5446_();
        float mouseAngleX = (float)Math.atan((float)(AdventMainGui.scaledRootX + 264 - mouseX) / 40.0f);
        float mouseAngleY = (float)Math.atan((float)(AdventMainGui.scaledRootY + 465 - 111 - mouseY) / 40.0f);
        poseStack.m_252880_(40.0f, 206.0f, 1050.0f);
        RenderUtil.drawCenteredScaledMessage(poseStack, mc.f_91062_, name, 0.0f, -104.0f, 1.0f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
        poseStack.m_85841_(1.0f, 1.0f, -1.0f);
        poseStack.m_85837_(0.0, 0.0, 1000.0);
        poseStack.m_85841_((float)scale * 0.625f, (float)scale * 0.625f, (float)scale * 0.625f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        float yawOffset = this.entityToRender.f_20883_;
        float prevYawOffset = this.entityToRender.f_20884_;
        float rotYaw = this.entityToRender.m_146908_();
        float rotPitch = this.entityToRender.m_146909_();
        float prevYawHead = this.entityToRender.f_20886_;
        float rotYawHead = this.entityToRender.f_20885_;
        this.entityToRender.f_20883_ = 0.0f;
        this.entityToRender.f_20884_ = 0.0f;
        this.entityToRender.m_146922_(mouseAngleX * 40.0f);
        this.entityToRender.m_146926_(-mouseAngleY * 20.0f);
        this.entityToRender.f_20885_ = this.entityToRender.m_146908_();
        this.entityToRender.f_20886_ = this.entityToRender.m_146908_();
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        MultiBufferSource.BufferSource renderBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_253146_((Vector3f)new Vector3f(0.2f, 0.5f, 1.0f).normalize(), (Vector3f)new Vector3f(-0.2f, -1.0f, -0.3f));
        renderManager.m_114468_(false);
        RenderSystem.m_69890_(() -> renderManager.m_114384_((Entity)this.entityToRender, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)renderBuffer, 0xF000F0));
        renderManager.m_114468_(true);
        renderBuffer.m_109911_();
        Lighting.m_84931_();
        this.entityToRender.f_20883_ = yawOffset;
        this.entityToRender.f_20884_ = prevYawOffset;
        this.entityToRender.m_146922_(rotYaw);
        this.entityToRender.m_146926_(rotPitch);
        this.entityToRender.f_20886_ = prevYawHead;
        this.entityToRender.f_20885_ = rotYawHead;
        poseStack.m_85849_();
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.entityToRender != null && !(this.entityToRender instanceof Player)) {
            this.entityToRender.m_146870_();
        }
        this.entityToRender = null;
    }

    private void setRenderEntity() {
        if (this.entityToRender == null) {
            Minecraft mc = Minecraft.m_91087_();
            this.entityToRender = !ClientPlayerDataManager.get().isLegitimate() ? (LivingEntity)((EntityType)((RegistryObject)RandomUtil.getRandomSelection((Object[])new RegistryObject[]{AoAMobs.ARCWORM, AoAMobs.CHARGER, AoAMobs.OCCULENT, AoAMobs.CYCLOPS, AoAMobs.STICKY, AoAMobs.KRANKY, AoAMobs.GINGERBREAD_MAN, AoAMobs.SHADE, AoAMobs.BOBO, AoAMobs.CHOCKO, AoAMobs.STITCHES, AoAMobs.BUGEYE, AoAMobs.SEA_TROLL, AoAMobs.ELITE_SKELE_PIG, AoAAnimals.SPEARMINT_SNAIL, AoAMobs.SHADOW, AoAMobs.ALARMO, AoAMobs.ANCIENT_GOLEM})).get()).m_20615_((Level)mc.f_91073_) : mc.f_91074_;
        }
    }

    public void m_6574_(Minecraft mc, int pWidth, int pHeight) {
        super.m_6574_(mc, pWidth, pHeight);
        if (this.abilityPane != null) {
            this.abilityPane.onResize(mc, AdventMainGui.scaledTabRootX + 250, AdventMainGui.scaledTabRootY + 50, 500, 280);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.abilityPane != null && this.abilityPane.skill != null) {
            if (this.hoveringSkillClose) {
                this.abilityPane.setSkill(null);
                return true;
            }
            if (this.hoveringAddCycle) {
                if (this.addCycleLastClicked < 0L) {
                    this.addCycleLastClicked = System.currentTimeMillis();
                    return true;
                }
                AoAPackets.messageServer(new AddSkillCyclePacket(this.abilityPane.skill.type()));
                return true;
            }
            if (this.abilityPane.handleMouseClick(this.adjustedMouseX, this.adjustedMouseY, button)) {
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.abilityPane != null && this.abilityPane.skill != null && this.abilityPane.handleMouseReleased(this.adjustedMouseX, this.adjustedMouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.abilityPane != null && this.abilityPane.skill != null && this.abilityPane.handleMouseScroll(this.adjustedMouseX, this.adjustedMouseY, delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private static class AbilityPane
    extends ScrollablePane {
        private AoASkill.Instance skill;
        private List<AoAAbility.Instance> sortedAbilities = null;
        private int hoveredAbility = -1;
        private float clickStartScroll = -1.0f;

        public AbilityPane(Minecraft mc, int top, int left, int viewHeight, int viewWidth, float renderingScale) {
            super(mc, top, left, viewHeight, viewWidth, renderingScale);
        }

        private void setSkill(AoASkill.Instance skill) {
            this.skill = skill;
            this.sortedAbilities = skill == null ? null : skill.getAbilityMap().values().stream().sorted(Comparator.comparingInt(AoAAbility.Instance::getLevelReq)).collect(Collectors.toList());
        }

        @Override
        public int getFullPaneHeight() {
            return this.skill != null ? this.viewHeight + this.skill.getAbilityMap().size() * 25 - 140 : 0;
        }

        @Override
        public boolean handleMouseClick(double mouseX, double mouseY, int button) {
            if (!this.isMouseHovering()) {
                return false;
            }
            this.clickStartScroll = this.distanceScrolled;
            return super.handleMouseClick(mouseX, mouseY, button);
        }

        @Override
        public boolean handleMouseReleased(double mouseX, double mouseY, int button) {
            AoAAbility.Instance instance;
            boolean wasDragging = this.isDragging;
            this.isDragging = false;
            if (!this.isMouseHovering()) {
                return false;
            }
            if (wasDragging && this.clickStartScroll == this.distanceScrolled && this.hoveredAbility != -1 && (instance = this.sortedAbilities.get(this.hoveredAbility)).onGuiClick(this.mouseX - this.left, this.mouseY - this.top - this.hoveredAbility * 50 + (int)this.distanceScrolled * 2)) {
                AoAPackets.messageServer(new ToggleAoAAbilityPacket(this.skill.type(), instance));
            }
            return super.handleMouseReleased(mouseX, mouseY, button);
        }

        @Override
        public void drawPaneContents(PoseStack matrix, int top, int left, int right, int bottom, float scrollDistance, float partialTicks) {
            Minecraft mc = Minecraft.m_91087_();
            Font font = mc.f_91062_;
            float center = (float)(right - left) / 2.0f;
            this.hoveredAbility = this.isMouseHovering() && this.mouseX < right - 8 ? Math.min((int)(-(((float)(top - this.mouseY) - scrollDistance) / 50.0f)), this.sortedAbilities.size() - 1) : -1;
            matrix.m_85836_();
            matrix.m_252880_((float)left, (float)top, 0.0f);
            matrix.m_252880_(0.0f, -scrollDistance, 0.0f);
            for (int i = 0; i < this.sortedAbilities.size(); ++i) {
                boolean abilityHoverEffects;
                AoAAbility.Instance ability = this.sortedAbilities.get(i);
                int colour = ColourUtil.RGB(100, 100, 100);
                boolean bl = abilityHoverEffects = this.hoveredAbility == i && this.sortedAbilities.get(this.hoveredAbility).onGuiHover(this.mouseX - left, this.mouseY - top - (i * 50 - (int)scrollDistance));
                if (ability.getListenerState() == AoAPlayerEventListener.ListenerState.ACTIVE) {
                    colour = abilityHoverEffects ? ColourUtil.RGB(255, 255, 180) : ColourUtil.WHITE;
                } else if (ability.getListenerState() == AoAPlayerEventListener.ListenerState.MANUALLY_DISABLED && abilityHoverEffects) {
                    colour = ColourUtil.RGB(150, 150, 100);
                }
                RenderUtil.drawScaledString(matrix, font, String.valueOf(ability.getLevelReq()), 5, 2, 1.5f, colour, RenderUtil.StringRenderType.OUTLINED);
                RenderUtil.drawCenteredScaledMessage(matrix, font, (Component)ability.getName(), center, 2.0f, 1.5f, colour, RenderUtil.StringRenderType.OUTLINED);
                matrix.m_252880_(0.0f, 20.0f, 0.0f);
                RenderUtil.drawWrappedMessage(matrix, font, (Component)ability.getDescription(), 5.0f, 2.0f, right - left - 10, colour);
                matrix.m_252880_(0.0f, 30.0f, 0.0f);
            }
            matrix.m_85849_();
        }

        @Override
        public void drawBackground(PoseStack matrix) {
        }
    }

    private static class SkillEntry
    extends Button {
        private final AdventGuiTabPlayer tab;
        private final AoASkillRenderer renderer;
        private final AoASkill.Instance skill;
        private final float scale;

        private SkillEntry(AdventGuiTabPlayer tab, float posX, float posY, AoASkillRenderer renderer, AoASkill.Instance instance, float scale) {
            super((int)posX, (int)posY, renderer.guiRenderHeight(instance), renderer.guiRenderWidth(instance), (Component)instance.getName(), button -> {}, f_252438_);
            this.tab = tab;
            this.renderer = renderer;
            this.skill = instance;
            this.scale = 3.2f * scale;
        }

        public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                this.f_93622_ = this.m_5953_(mouseX - AdventMainGui.scaledTabRootX, mouseY - AdventMainGui.scaledTabRootY);
                poseStack.m_85836_();
                poseStack.m_85841_(2.0f, 2.0f, 1.0f);
                poseStack.m_252880_((float)this.m_252754_(), (float)this.m_252907_(), 0.0f);
                this.renderer.renderInGui(poseStack, this.skill, partialTicks, mouseX, mouseY, (AoASkillRenderer.ProgressRenderType)((Object)AoAConfigs.CLIENT.hudSkillProgressRenderType.get()), true);
                poseStack.m_252880_(0.0f, -5.0f, 0.0f);
                poseStack.m_85841_(0.5f, 0.5f, 1.0f);
                RenderUtil.drawCenteredScaledMessage(poseStack, Minecraft.m_91087_().f_91062_, this.m_6035_(), this.f_93618_, 0.0f, 1.0f, this.f_93622_ ? ColourUtil.RGB(255, 255, 100) : ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
                poseStack.m_85849_();
            }
        }

        protected boolean m_93680_(double pMouseX, double pMouseY) {
            return this.f_93622_;
        }

        public void m_5716_(double pMouseX, double pMouseY) {
            this.tab.abilityPane.setSkill(this.skill);
            this.f_93622_ = false;
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            if (!this.f_93623_ || !this.f_93624_) {
                return false;
            }
            if (mouseX <= (double)((float)this.m_252754_() * this.scale)) {
                return false;
            }
            if (mouseX >= (double)((float)this.m_252754_() * this.scale + (float)this.f_93618_ * this.scale)) {
                return false;
            }
            if (mouseY <= (double)((float)(this.m_252907_() * 2) * 1.6f)) {
                return false;
            }
            return mouseY < (double)((float)this.m_252907_() * this.scale + (float)this.f_93619_ * this.scale);
        }
    }
}

