/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.adventgui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.tslat.aoa3.client.gui.adventgui.AdventMainGui;
import net.tslat.aoa3.integration.IntegrationManager;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class AdventGuiTabHelp
extends Screen {
    private int tipNumber = RandomUtil.randomNumberUpTo((int)(IntegrationManager.isPatchouliActive() ? 12 : 13));

    protected AdventGuiTabHelp() {
        super((Component)Component.m_237115_((String)"gui.aoa3.adventGui.help"));
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)new ThemeButton(640, 35, 30, 40));
        this.m_142416_((GuiEventListener)new WebLinkButton(this.getMinecraft(), 640, 130, 76, 18, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.linkDiscord"), this.stringToURI("https://discord.gg/DNYqNNq")));
        this.m_142416_((GuiEventListener)new WebLinkButton(this.getMinecraft(), 640, 170, 108, 18, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.linkWiki"), this.stringToURI("https://adventofascension.gamepedia.com/Advent_of_Ascension_Wiki")));
        this.m_142416_((GuiEventListener)new WebLinkButton(this.getMinecraft(), 640, 210, 60, 18, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.linkGithub"), this.stringToURI("https://github.com/Tslat/Advent-Of-Ascension")));
        this.m_142416_((GuiEventListener)new WebLinkButton(this.getMinecraft(), 640, 250, 80, 18, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.linkPatreon"), this.stringToURI("https://www.patreon.com/Tslat")));
        this.m_142416_((GuiEventListener)new WebLinkButton(this.getMinecraft(), 640, 290, 68, 18, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.linkUpdate"), this.stringToURI("https://adventofascension.gamepedia.com/Download")));
    }

    public void m_86412_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        RenderUtil.drawVerticalGradient(matrix, AdventMainGui.scaledTabRootX + 35, AdventMainGui.scaledTabRootY + 55, 0, 570, 225, -1072689136, -804253680);
        RenderUtil.drawCenteredScaledMessage(matrix, this.f_96547_, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.theme"), AdventMainGui.scaledTabRootX + 672, AdventMainGui.scaledTabRootY + 10, 2.0f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
        RenderUtil.drawCenteredScaledMessage(matrix, this.f_96547_, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.links"), AdventMainGui.scaledTabRootX + 672, AdventMainGui.scaledTabRootY + 100, 2.0f, ColourUtil.WHITE, RenderUtil.StringRenderType.OUTLINED);
        RenderUtil.drawScaledMessage(matrix, this.f_96547_, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.title"), AdventMainGui.scaledTabRootX + 80, AdventMainGui.scaledTabRootY + 25, 2.5f, ColourUtil.RGB(239, 137, 119), RenderUtil.StringRenderType.OUTLINED);
        matrix.m_85836_();
        matrix.m_85841_(1.5625f, 1.5625f, 1.5625f);
        RenderUtil.drawWrappedMessage(matrix, this.f_96547_, (Component)Component.m_237113_((String)LocaleUtil.getLocaleString("gui.aoa3.adventGui.help.description").replace("<br>", "\n")), (int)((float)(AdventMainGui.scaledTabRootX + 40) / 1.5625f), (int)((float)(AdventMainGui.scaledTabRootY + 60) / 1.5625f), 360, ColourUtil.WHITE);
        matrix.m_85849_();
        RenderUtil.drawScaledMessage(matrix, this.f_96547_, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.tip", new Component[]{LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.tip." + this.tipNumber)}), AdventMainGui.scaledTabRootX + 30, AdventMainGui.scaledTabRootY + 310, 1.8f, ColourUtil.WHITE, RenderUtil.StringRenderType.DROP_SHADOW);
        super.m_86412_(matrix, mouseX, mouseY, partialTicks);
    }

    private static void openURL(URI url) {
        Util.m_137581_().m_137648_(url);
    }

    @Nullable
    private URI stringToURI(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static class ThemeButton
    extends Button {
        public ThemeButton(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.m_237113_((String)AdventMainGui.theme.name()), button -> {}, f_252438_);
        }

        public void m_5716_(double mouseX, double mouseY) {
            AdventMainGui.changeTheme();
            this.m_93666_((Component)Component.m_237113_((String)AdventMainGui.theme.name()));
            this.m_93692_(false);
        }

        public void m_86412_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                Minecraft mc = Minecraft.m_91087_();
                this.f_93622_ = this.isMouseInRegion(mouseX, mouseY, this.m_252754_(), this.m_252907_());
                this.f_93618_ = (int)(10.0f + (float)Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.m_6035_()) * 1.5f);
                RenderSystem.m_157427_(GameRenderer::m_172820_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)AdventMainGui.theme.menuButtonTexture());
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderUtil.renderScaledCustomSizedTexture(matrix, AdventMainGui.scaledTabRootX + this.m_252754_(), AdventMainGui.scaledTabRootY + this.m_252907_(), 0.0f, this.f_93622_ ? 60.0f : 0.0f, 180.0f, 60.0f, this.f_93618_, this.f_93619_, 180.0f, 180.0f);
                int stringColour = 0xE0E0E0;
                if (this.getFGColor() != 0) {
                    stringColour = this.getFGColor();
                } else if (!this.f_93623_) {
                    stringColour = 0xA0A0A0;
                } else if (this.f_93622_) {
                    stringColour = 0xFFFFA0;
                }
                RenderUtil.drawCenteredScaledMessage(matrix, mc.f_91062_, this.m_6035_(), (int)((float)(AdventMainGui.scaledTabRootX + this.m_252754_()) + (float)this.f_93618_ / 2.0f), (int)((double)(AdventMainGui.scaledTabRootY + this.m_252907_()) + (double)this.f_93619_ / 2.5), 1.5f, stringColour, RenderUtil.StringRenderType.DROP_SHADOW);
            }
        }

        protected boolean m_93680_(double p_clicked_1_, double p_clicked_3_) {
            return this.f_93623_ && this.f_93622_;
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= (int)((float)(AdventMainGui.scaledTabRootX + buttonX) * 0.45f) && mouseX <= (int)((float)(AdventMainGui.scaledTabRootX + buttonX + this.f_93618_) * 0.45f) && mouseY >= (int)((float)(AdventMainGui.scaledTabRootY + buttonY) * 0.45f) && mouseY <= (int)((float)(AdventMainGui.scaledTabRootY + buttonY + this.f_93619_) * 0.45f);
        }
    }

    private static class WebLinkButton
    extends Button {
        private final URI url;

        public WebLinkButton(Minecraft mc, int x, int y, int width, int height, Component name, URI link) {
            super(x, y, width, height, name, button -> {}, f_252438_);
            this.url = link;
            if (this.url == null) {
                this.f_93623_ = false;
                this.f_93624_ = false;
            } else {
                this.f_93618_ = (int)((float)mc.f_91062_.m_92852_((FormattedText)this.m_6035_()) * 2.0f);
            }
        }

        public void m_5716_(double mouseX, double mouseY) {
            AdventGuiTabHelp.openURL(this.url);
        }

        public void m_86412_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                Minecraft mc = Minecraft.m_91087_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.f_93622_ = this.isMouseInRegion(mouseX, mouseY, this.m_252754_(), this.m_252907_());
                int stringColour = ColourUtil.RGB(239, 137, 119);
                if (this.f_93622_) {
                    stringColour = ColourUtil.RGB(247, 239, 0);
                }
                RenderUtil.drawCenteredScaledMessage(matrix, mc.f_91062_, this.m_6035_(), (int)((float)(AdventMainGui.scaledTabRootX + this.m_252754_()) + (float)this.f_93618_ / 2.0f), AdventMainGui.scaledTabRootY + this.m_252907_(), 2.0f, stringColour, RenderUtil.StringRenderType.OUTLINED);
            }
        }

        protected boolean m_93680_(double p_clicked_1_, double p_clicked_3_) {
            return this.f_93623_ && this.f_93622_;
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= (int)((float)(AdventMainGui.scaledTabRootX + buttonX) * 0.45f) && mouseX <= (int)((float)(AdventMainGui.scaledTabRootX + buttonX + this.f_93618_) * 0.45f) && mouseY >= (int)((float)(AdventMainGui.scaledTabRootY + buttonY) * 0.45f) && mouseY <= (int)((float)(AdventMainGui.scaledTabRootY + buttonY + this.f_93619_) * 0.45f);
        }
    }
}

