/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.tslat.aoa3.client.gui.hud.RecoilRenderer;
import net.tslat.aoa3.client.gui.hud.toasts.AbilityUnlockToast;
import net.tslat.aoa3.client.gui.hud.toasts.LevelRequirementToast;
import net.tslat.aoa3.client.gui.hud.toasts.ResourceRequirementToast;
import net.tslat.aoa3.client.gui.realmstone.BlankRealmstoneScreen;
import net.tslat.aoa3.client.particle.BurningFlameParticle;
import net.tslat.aoa3.client.particle.FireAuraParticle;
import net.tslat.aoa3.client.particle.FlickeringSparklerParticle;
import net.tslat.aoa3.client.particle.FloatingItemFragmentParticle;
import net.tslat.aoa3.client.particle.FreezingSnowflakeParticle;
import net.tslat.aoa3.client.particle.LingeringSparklerParticle;
import net.tslat.aoa3.client.particle.OrbParticle;
import net.tslat.aoa3.client.particle.PortalFloaterParticle;
import net.tslat.aoa3.client.particle.RainbowSparklerParticle;
import net.tslat.aoa3.client.particle.SandstormParticle;
import net.tslat.aoa3.client.particle.SparklerParticle;
import net.tslat.aoa3.client.particle.SwirlyParticle;
import net.tslat.aoa3.client.render.entity.misc.OccultBlockRenderer;
import net.tslat.aoa3.common.packet.packets.ToastPopupPacket;
import net.tslat.aoa3.common.packet.packets.UpdateClientMovementPacket;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.mob.greckon.SilencerEntity;
import net.tslat.aoa3.content.item.misc.WornBook;
import net.tslat.aoa3.library.builder.ParticleBuilder;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.player.ClientPlayerDataManager;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;

public final class ClientOperations {
    public static final ClientPlayerDataManager CLIENT_PLAYER_DATA = new ClientPlayerDataManager();

    public static Level getWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static Player getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static void displayWornBookGui() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack bookStack = player.m_21205_().m_41720_() == AoAItems.WORN_BOOK.get() ? player.m_21205_() : player.m_21206_();
        Minecraft.m_91087_().m_91152_((Screen)new BookViewScreen((BookViewScreen.BookAccess)new BookViewScreen.WrittenBookAccess(WornBook.getBook(bookStack))));
    }

    public static void displayBlankRealmstoneGui() {
        Minecraft.m_91087_().m_91152_((Screen)new BlankRealmstoneScreen());
    }

    public static void addRecoil(float recoil, int firingTime) {
        RecoilRenderer.addRecoil(recoil);
    }

    public static void addOccultBlocks(int renderUntil, List<OccultBlockRenderer.OccultBlock> blocks) {
        OccultBlockRenderer.addOccultBlocks(renderUntil, blocks);
    }

    public static void registerParticleFactories(RegisterParticleProvidersEvent ev) {
        ev.registerSpriteSet((ParticleType)AoAParticleTypes.PORTAL_FLOATER.get(), PortalFloaterParticle.Factory::new);
        ev.registerSpriteSet((ParticleType)AoAParticleTypes.SPARKLER.get(), SparklerParticle.Factory::new);
        ev.registerSpriteSet((ParticleType)AoAParticleTypes.FLICKERING_SPARKLER.get(), FlickeringSparklerParticle.Factory::new);
        ev.registerSpriteSet((ParticleType)AoAParticleTypes.LINGERING_SPARKLER.get(), LingeringSparklerParticle.Factory::new);
        ev.registerSpriteSet((ParticleType)AoAParticleTypes.RAINBOW_SPARKLER.get(), RainbowSparklerParticle.Factory::new);
        ev.registerSpriteSet((ParticleType)AoAParticleTypes.SWIRLY.get(), SwirlyParticle.Factory::new);
        ev.registerSpecial((ParticleType)AoAParticleTypes.FLOATING_ITEM_FRAGMENT.get(), (ParticleProvider)new FloatingItemFragmentParticle.Factory());
        ev.registerSpriteSet((ParticleType)AoAParticleTypes.FREEZING_SNOWFLAKE.get(), FreezingSnowflakeParticle.Factory::new);
        ev.registerSpriteSet((ParticleType)AoAParticleTypes.BURNING_FLAME.get(), BurningFlameParticle.Factory::new);
        ev.registerSpriteSet((ParticleType)AoAParticleTypes.SANDSTORM.get(), SandstormParticle.Factory::new);
        ev.registerSpriteSet((ParticleType)AoAParticleTypes.ORB.get(), OrbParticle.Factory::new);
        ev.registerSpriteSet((ParticleType)AoAParticleTypes.FIRE_AURA.get(), FireAuraParticle.Factory::new);
    }

    public static void addToast(ToastPopupPacket.ToastPopupType type, Object subject, Object value) {
        switch (type) {
            case SKILL_REQUIREMENT: {
                AoASkill skill = AoASkills.getSkill((ResourceLocation)subject);
                if (((Boolean)AoAConfigs.CLIENT.useToasts.get()).booleanValue()) {
                    Minecraft.m_91087_().m_91300_().m_94922_((Toast)new LevelRequirementToast(skill, (Integer)value));
                    break;
                }
                Minecraft.m_91087_().f_91074_.m_213846_((Component)LocaleUtil.getLocaleMessage("message.feedback.insufficientLevels", ChatFormatting.RED, new Component[]{skill.getName(), LocaleUtil.numToComponent((Integer)value)}));
                break;
            }
            case RESOURCE_REQUIREMENT: {
                AoAResource resource = AoAResources.getResource((ResourceLocation)subject);
                if (((Boolean)AoAConfigs.CLIENT.useToasts.get()).booleanValue()) {
                    Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ResourceRequirementToast(resource, ((Float)value).floatValue()));
                    break;
                }
                Minecraft.m_91087_().f_91074_.m_213846_((Component)LocaleUtil.getLocaleMessage("message.feedback.insufficientResource", ChatFormatting.RED, new Component[]{resource.getName(), Component.m_237113_((String)NumberUtil.roundToNthDecimalPlace(((Float)value).floatValue(), 2))}));
                break;
            }
            case ABILITY_UNLOCK: {
                AoASkill skill2 = AoASkills.getSkill((ResourceLocation)subject);
                AoAAbility ability = AoAAbilities.getAbility((ResourceLocation)value);
                if (((Boolean)AoAConfigs.CLIENT.useToasts.get()).booleanValue()) {
                    Minecraft.m_91087_().m_91300_().m_94922_((Toast)new AbilityUnlockToast(skill2, ability));
                    break;
                }
                Minecraft.m_91087_().f_91074_.m_213846_((Component)LocaleUtil.getLocaleMessage("message.feedback.abilityUnlocked", ChatFormatting.GREEN, new Component[]{skill2.getName(), ability.getName()}));
            }
        }
    }

    public static void doSilencerSilence(SilencerEntity silencer) {
        if (!SilencerEntity.isClientNearby) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.m_91106_().f_120349_.m_120258_(SoundSource.MASTER) > 0.0f && silencer.m_20280_((Entity)mc.f_91074_) < 64.0) {
                SilencerEntity.isClientNearby = true;
                SilencerEntity.previousGain = mc.m_91106_().f_120349_.f_120221_.m_83744_();
                mc.m_91106_().f_120349_.m_120260_(SoundSource.MASTER, 0.0f);
            }
        }
    }

    public static void syncPatchouliBooks(ArrayList<ResourceLocation> books) {
    }

    public static void adjustPlayerMovement(@Nullable Float x, @Nullable Float y, @Nullable Float z, UpdateClientMovementPacket.Operation operation) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vec3 velocity = player.m_20184_();
        switch (operation) {
            case SET: {
                player.m_20334_(x != null ? (double)x.floatValue() : velocity.m_7096_(), y != null ? (double)y.floatValue() : velocity.m_7098_(), z != null ? (double)z.floatValue() : velocity.m_7094_());
                break;
            }
            case ADD: {
                player.m_20256_(velocity.m_82520_(x != null ? (double)x.floatValue() : 0.0, y != null ? (double)y.floatValue() : 0.0, z != null ? (double)z.floatValue() : 0.0));
                break;
            }
            case MULTIPLY: {
                player.m_20256_(velocity.m_82542_(x != null ? (double)x.floatValue() : 1.0, y != null ? (double)y.floatValue() : 1.0, z != null ? (double)z.floatValue() : 1.0));
                break;
            }
            case MAX: {
                player.m_20334_(x != null ? Math.min((double)x.floatValue(), velocity.m_7096_()) : velocity.m_7096_(), y != null ? Math.min((double)y.floatValue(), velocity.m_7098_()) : velocity.m_7098_(), z != null ? Math.min((double)z.floatValue(), velocity.m_7094_()) : velocity.m_7094_());
                break;
            }
            case MIN: {
                player.m_20334_(x != null ? Math.max((double)x.floatValue(), velocity.m_7096_()) : velocity.m_7096_(), y != null ? Math.max((double)y.floatValue(), velocity.m_7098_()) : velocity.m_7098_(), z != null ? Math.max((double)z.floatValue(), velocity.m_7094_()) : velocity.m_7094_());
            }
        }
    }

    public static boolean harvestAdditionalBlock(BlockPos breakPos) {
        if (Minecraft.m_91087_().f_91072_ == null) {
            return false;
        }
        return Minecraft.m_91087_().f_91072_.m_105267_(breakPos);
    }

    public static Component getPlayerName() {
        return Minecraft.m_91087_().f_91074_.m_5446_();
    }

    public static void addParticle(ParticleBuilder particleBuilder, @Nullable Consumer particleConsumer) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91061_ == null) {
            return;
        }
        Camera camera = mc.f_91063_.m_109153_();
        if (!camera.m_90593_()) {
            return;
        }
        if (!particleBuilder.getShouldForce() && mc.f_91060_.m_109767_(particleBuilder.getIsAmbient()) == ParticleStatus.MINIMAL) {
            return;
        }
        Supplier<Vec3> nextPos = particleBuilder.getPositionGenerator();
        double cutoffDist = particleBuilder.getShouldForce() ? -1.0 : Math.pow(particleBuilder.getCutoffDistance(), 2.0);
        Vec3 velocity = particleBuilder.getVelocity();
        for (int i = 0; i < particleBuilder.getCount(); ++i) {
            Vec3 pos = nextPos.get();
            if (!particleBuilder.getShouldForce() && camera.m_90583_().m_82557_(pos) > cutoffDist) continue;
            for (int j = 0; j < particleBuilder.getCountPerPosition(); ++j) {
                Particle particle = mc.f_91061_.m_107370_(particleBuilder.getParticle(), pos.f_82479_, pos.f_82480_, pos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
                if (particle == null) continue;
                if (particleBuilder.getColourOverride() != null) {
                    ColourUtil.Colour colour = particleBuilder.getColourOverride();
                    particle.m_107253_(colour.red(), colour.green(), colour.blue());
                    particle.m_107271_(colour.alpha());
                }
                if (particleBuilder.getLifespan() > 0) {
                    particle.m_107257_(particleBuilder.getLifespan());
                }
                if (particleBuilder.getGravity() != Float.MAX_VALUE) {
                    particle.f_107226_ = particleBuilder.getGravity();
                }
                if (particleBuilder.getInertia() > 0.0f) {
                    particle.f_172258_ = particleBuilder.getInertia();
                }
                if (particleBuilder.getScaleMod() != 1.0f) {
                    particle.m_6569_(particleBuilder.getScaleMod());
                }
                if (particleConsumer == null) continue;
                particleConsumer.accept(particle);
            }
        }
    }

    public static GameType getGameMode() {
        return Minecraft.m_91087_().f_91072_.m_105295_();
    }

    public static boolean isPressingCrouchKey() {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.getKey().m_84873_());
    }

    public static void playSoundFromBuilder(final SoundBuilder soundBuilder) {
        Minecraft minecraft = Minecraft.m_91087_();
        double delay = (double)soundBuilder.getScheduledDelay() + (soundBuilder.getApplyTimeDilation() ? Math.sqrt(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82557_(soundBuilder.getLocation())) * 0.5 : 0.0);
        if (soundBuilder.getCategory() == SoundSource.MUSIC) {
            Music music = new Music(BuiltInRegistries.f_256894_.m_263177_((Object)soundBuilder.getSound()), soundBuilder.getScheduledDelay(), soundBuilder.getScheduledDelay(), true);
            if (!minecraft.m_91397_().m_120187_(music)) {
                minecraft.m_91397_().m_120186_();
                minecraft.m_91397_().m_120184_(music);
            }
            return;
        }
        Object sound = soundBuilder.getFollowingEntity() != null ? new EntityBoundSoundInstance(soundBuilder.getSound(), soundBuilder.getCategory(), soundBuilder.getRadius() / 16.0f, soundBuilder.getPitch(), soundBuilder.getFollowingEntity(), soundBuilder.getSeed()){

            public boolean m_7775_() {
                return soundBuilder.getIsLooping();
            }

            public int m_7766_() {
                return soundBuilder.getLoopDelay();
            }
        } : (soundBuilder.getLocation() != null ? new SimpleSoundInstance(soundBuilder.getSound().m_11660_(), soundBuilder.getCategory(), soundBuilder.getRadius() / 16.0f, soundBuilder.getPitch(), RandomSource.m_216335_((long)soundBuilder.getSeed()), soundBuilder.getIsLooping(), (int)delay, soundBuilder.getIsInWorld() ? SoundInstance.Attenuation.LINEAR : SoundInstance.Attenuation.NONE, soundBuilder.getLocation().m_7096_(), soundBuilder.getLocation().m_7098_(), soundBuilder.getLocation().m_7094_(), false) : new SimpleSoundInstance(soundBuilder.getSound().m_11660_(), soundBuilder.getCategory(), soundBuilder.getRadius() / 16.0f, soundBuilder.getPitch(), RandomSource.m_216335_((long)soundBuilder.getSeed()), soundBuilder.getIsLooping(), (int)delay, soundBuilder.getIsInWorld() ? SoundInstance.Attenuation.LINEAR : SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, false));
        if (delay > 0.0) {
            minecraft.m_91106_().m_120369_((SoundInstance)sound, (int)delay);
        } else {
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    public static void stopSoundFromBuilder(SoundBuilder soundBuilder) {
        if (soundBuilder.getCategory() == SoundSource.MUSIC) {
            Music music = new Music(BuiltInRegistries.f_256894_.m_263177_((Object)soundBuilder.getSound()), soundBuilder.getScheduledDelay(), soundBuilder.getScheduledDelay(), true);
            MusicManager musicManager = Minecraft.m_91087_().m_91397_();
            if (musicManager.m_120187_(music)) {
                musicManager.m_120186_();
            }
        } else {
            Minecraft.m_91087_().m_91106_().m_120386_(soundBuilder.getSound().m_11660_(), soundBuilder.getCategory());
        }
    }
}

