/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public final class AoAStartupCache {
    private static final List<Pair<Supplier<ItemStack>, List<Supplier<CreativeModeTab>>>> CREATIVE_TABS = new ObjectArrayList(2500);

    public static void setItemCreativeTab(Supplier<? extends Item> item, Supplier<CreativeModeTab> ... creativeTabs) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            CREATIVE_TABS.add((Pair<Supplier<ItemStack>, List<Supplier<CreativeModeTab>>>)Pair.of(() -> new ItemStack((ItemLike)item.get()), (Object)ObjectArrayList.of((Object[])creativeTabs)));
        }
    }

    public static void setItemStackCreativeTab(Supplier<ItemStack> stack, Supplier<CreativeModeTab> ... creativeTabs) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            CREATIVE_TABS.add((Pair<Supplier<ItemStack>, List<Supplier<CreativeModeTab>>>)Pair.of(stack, (Object)ObjectArrayList.of((Object[])creativeTabs)));
        }
    }

    public static List<ItemStack> getItemsForTab(CreativeModeTab tab) {
        ObjectArrayList list = new ObjectArrayList();
        for (Pair<Supplier<ItemStack>, List<Supplier<CreativeModeTab>>> entry : CREATIVE_TABS) {
            for (Supplier creativeModeTabSupplier : (List)entry.right()) {
                if (creativeModeTabSupplier.get() != tab) continue;
                list.add((ItemStack)((Supplier)entry.left()).get());
            }
        }
        return list;
    }

    public static void clear() {
    }
}

