/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent;

import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.client.AoAEntityRendering;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.client.event.ClientEventHandler;
import net.tslat.aoa3.client.gui.hud.BossBarRenderer;
import net.tslat.aoa3.client.gui.hud.HealthStatusRenderer;
import net.tslat.aoa3.client.gui.hud.RecoilRenderer;
import net.tslat.aoa3.client.gui.hud.XpParticlesRenderer;
import net.tslat.aoa3.client.gui.overlay.ScopeOverlayRenderer;
import net.tslat.aoa3.client.gui.overlay.ScreenEffectRenderer;
import net.tslat.aoa3.client.model.ModelProperties;
import net.tslat.aoa3.client.render.AoAGuiElementRenderers;
import net.tslat.aoa3.client.render.CustomDimensionRenders;
import net.tslat.aoa3.client.render.entity.misc.OccultBlockRenderer;
import net.tslat.aoa3.common.misc.NativePatching;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.registration.AoAAdvancementTriggers;
import net.tslat.aoa3.common.registration.AoACapabilities;
import net.tslat.aoa3.common.registration.AoACommands;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.AoAContainers;
import net.tslat.aoa3.common.registration.AoACreativeModeTabs;
import net.tslat.aoa3.common.registration.AoADatapackLoaders;
import net.tslat.aoa3.common.registration.AoADispensables;
import net.tslat.aoa3.common.registration.AoAGameRules;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAVillagerTrades;
import net.tslat.aoa3.data.client.AoAResourceReloadListeners;
import net.tslat.aoa3.event.AoAPlayerEvents;
import net.tslat.aoa3.event.EntityEvents;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.event.PlayerEvents;
import net.tslat.aoa3.event.RestrictionEventHandler;
import net.tslat.aoa3.integration.IntegrationManager;
import net.tslat.aoa3.util.WebUtil;
import software.bernie.geckolib.GeckoLib;

@Mod(value="aoa3")
public class AdventOfAscension {
    public static final String VERSION = "1.19.4-3.6.25";
    public static final String MOD_ID = "aoa3";
    public static final IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();

    public AdventOfAscension() {
        Logging.logStatusMessage("!~ Advent of Ascension v1.19.4-3.6.25 ~!");
        AdventOfAscension.initRegistrations();
        AdventOfAscension.initEventHandlers();
        GeckoLib.initialize();
        NativePatching.init();
        IntegrationManager.init();
    }

    private static void initRegistrations() {
        AoAConfigs.init();
        AoARegistries.init();
        AoADatapackLoaders.init();
        AoACapabilities.init();
        AoACommands.init();
        AoAAdvancementTriggers.registerTriggers();
        AoAPackets.init();
        AoAEntityStats.init();
        AoAVillagerTrades.init();
        AoACreativeModeTabs.init();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            AoAEntityRendering.init();
            ClientEventHandler.init();
            AoAGuiElementRenderers.init();
            AoAKeybinds.init();
            AoAResourceReloadListeners.init();
            ScopeOverlayRenderer.init();
            XpParticlesRenderer.init();
            ScreenEffectRenderer.init();
            CustomDimensionRenders.init();
        });
    }

    private static void initEventHandlers() {
        modEventBus.addListener(EventPriority.NORMAL, false, FMLCommonSetupEvent.class, AdventOfAscension::commonSetup);
        modEventBus.addListener(EventPriority.NORMAL, false, FMLClientSetupEvent.class, AdventOfAscension::clientSetup);
        modEventBus.addListener(EventPriority.NORMAL, false, FMLLoadCompleteEvent.class, AdventOfAscension::loadFinished);
        RestrictionEventHandler.preInit();
        PlayerEvents.preInit();
        GlobalEvents.preInit();
        EntityEvents.preInit();
        AoAPlayerEvents.preInit();
    }

    private static void commonSetup(FMLCommonSetupEvent ev) {
        ev.enqueueWork(() -> {
            AoAGameRules.lateInit();
            AoADispensables.lateInit();
            NativePatching.lateInit();
            IntegrationManager.lateInit();
            AoAEntitySpawnPlacements.lateInit();
        });
    }

    private static void clientSetup(FMLClientSetupEvent ev) {
        ev.enqueueWork(() -> {
            AoABlocks.applyFluidRenderTypes();
            AoAContainers.registerContainerScreens();
            ModelProperties.init();
            AoAGuiElementRenderers.lateInit();
        });
        BossBarRenderer.init();
        RecoilRenderer.init();
        HealthStatusRenderer.init();
        OccultBlockRenderer.init();
    }

    private static void loadFinished(FMLLoadCompleteEvent ev) {
        WebUtil.doHTTPTasks();
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

