/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.options;

import com.teamresourceful.resourcefulconfig.client.options.DoubleSlider;
import com.teamresourceful.resourcefulconfig.client.options.LongSlider;
import com.teamresourceful.resourcefulconfig.client.options.NumberInputBox;
import com.teamresourceful.resourcefulconfig.common.annotations.ByteRange;
import com.teamresourceful.resourcefulconfig.common.annotations.DoubleRange;
import com.teamresourceful.resourcefulconfig.common.annotations.FloatRange;
import com.teamresourceful.resourcefulconfig.common.annotations.IntRange;
import com.teamresourceful.resourcefulconfig.common.annotations.LongRange;
import com.teamresourceful.resourcefulconfig.common.annotations.ShortRange;
import com.teamresourceful.resourcefulconfig.common.config.EntryType;
import com.teamresourceful.resourcefulconfig.common.config.ParsingUtils;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfigEntry;
import it.unimi.dsi.fastutil.doubles.DoubleConsumer;
import it.unimi.dsi.fastutil.doubles.DoubleDoublePair;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import java.util.function.LongConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public final class Options {
    public static AbstractWidget create(int x, int y, int width, ResourcefulConfigEntry entry) {
        if (entry.field().getType().isArray()) {
            Button button = Button.m_253074_((Component)CommonComponents.f_238772_, widget -> {}).m_252987_(x, y, width, 20).m_253136_();
            button.f_93623_ = false;
            return button;
        }
        return switch (entry.type()) {
            default -> throw new IncompatibleClassChangeError();
            case EntryType.BOOLEAN -> Options.createBoolean(x, y, width, 20, entry);
            case EntryType.BYTE, EntryType.SHORT, EntryType.INTEGER, EntryType.LONG -> Options.createInt(x, y, width, 20, entry);
            case EntryType.FLOAT, EntryType.DOUBLE -> Options.createFloat(x, y, width, 20, entry);
            case EntryType.STRING -> new CycleButton(Minecraft.m_91087_().f_91062_, x, y, width, 20, entry);
            case EntryType.ENUM -> Options.createEnum(x, y, width, 20, entry);
        };
    }

    public static CycleButton<Enum<?>> createEnum(int x, int y, int width, int height, ResourcefulConfigEntry entry) {
        if (entry.type() != EntryType.ENUM) {
            throw new IllegalArgumentException("Entry is not an enum!");
        }
        ?[] values = entry.field().getType().getEnumConstants();
        CycleButton.Builder builder = CycleButton.m_168894_(value -> Component.m_237113_((String)value.name()));
        builder.m_168961_((Object[])((Enum[])values));
        builder.m_168948_((Object)((Enum)ParsingUtils.getField(entry.field())));
        builder.m_168929_();
        return builder.m_168936_(x, y, width, height, CommonComponents.f_237098_, (button, value) -> entry.setEnum((Enum<?>)value));
    }

    public static CycleButton<Boolean> createBoolean(int x, int y, int width, int height, ResourcefulConfigEntry entry) {
        if (entry.type() != EntryType.BOOLEAN) {
            throw new IllegalArgumentException("Entry is not a boolean!");
        }
        CycleButton.Builder builder = CycleButton.m_168896_((Component)CommonComponents.f_130653_, (Component)CommonComponents.f_130654_);
        builder.m_168948_((Object)((Boolean)ParsingUtils.getField(entry.field())));
        builder.m_168929_();
        return builder.m_168936_(x, y, width, height, CommonComponents.f_237098_, (button, value) -> entry.setBoolean((boolean)value));
    }

    public static AbstractWidget createInt(int x, int y, int width, int height, ResourcefulConfigEntry entry) {
        if (entry.type() != EntryType.INTEGER && entry.type() != EntryType.BYTE && entry.type() != EntryType.SHORT && entry.type() != EntryType.LONG) {
            throw new IllegalArgumentException("Entry is not an integer!");
        }
        it.unimi.dsi.fastutil.longs.LongConsumer setter = value -> {
            switch (entry.type()) {
                case BYTE: {
                    entry.setByte((byte)value);
                    break;
                }
                case SHORT: {
                    entry.setShort((short)value);
                    break;
                }
                case INTEGER: {
                    entry.setInt((int)value);
                    break;
                }
                case LONG: {
                    entry.setLong(value);
                }
            }
        };
        LongLongPair range = Options.getMinMax(entry);
        if (range == null) {
            return new NumberInputBox(Minecraft.m_91087_().f_91062_, x, y, width, height, ParsingUtils.getField(entry.field()).toString(), false, (LongConsumer)setter, null);
        }
        Number number = (Number)ParsingUtils.getField(entry.field());
        return new LongSlider(x, y, width, height, (Component)Component.m_237113_((String)entry.field().getName()), number.longValue(), range.firstLong(), range.secondLong(), (LongConsumer)setter);
    }

    public static AbstractWidget createFloat(int x, int y, int width, int height, ResourcefulConfigEntry entry) {
        if (entry.type() != EntryType.FLOAT && entry.type() != EntryType.DOUBLE) {
            throw new IllegalArgumentException("Entry is not an float!");
        }
        DoubleConsumer setter = value -> {
            switch (entry.type()) {
                case FLOAT: {
                    entry.setFloat((float)value);
                    break;
                }
                case DOUBLE: {
                    entry.setDouble(value);
                }
            }
        };
        DoubleDoublePair range = Options.getFloatingMinMax(entry);
        if (range == null) {
            return new NumberInputBox(Minecraft.m_91087_().f_91062_, x, y, width, height, ParsingUtils.getField(entry.field()).toString(), true, null, (java.util.function.DoubleConsumer)setter);
        }
        Number number = (Number)ParsingUtils.getField(entry.field());
        return new DoubleSlider(x, y, width, height, (Component)Component.m_237113_((String)entry.field().getName()), number.doubleValue(), range.firstDouble(), range.secondDouble(), (java.util.function.DoubleConsumer)setter);
    }

    private static DoubleDoublePair getFloatingMinMax(ResourcefulConfigEntry entry) {
        switch (entry.type()) {
            case DOUBLE: {
                DoubleRange range = entry.field().getAnnotation(DoubleRange.class);
                if (range == null) {
                    return null;
                }
                return DoubleDoublePair.of((double)range.min(), (double)range.max());
            }
            case FLOAT: {
                FloatRange range = entry.field().getAnnotation(FloatRange.class);
                if (range == null) {
                    return null;
                }
                return DoubleDoublePair.of((double)range.min(), (double)range.max());
            }
        }
        return null;
    }

    private static LongLongPair getMinMax(ResourcefulConfigEntry entry) {
        return switch (entry.type()) {
            case EntryType.BYTE -> {
                ByteRange range = entry.field().getAnnotation(ByteRange.class);
                if (range != null) {
                    yield LongLongPair.of((long)range.min(), (long)range.max());
                }
                yield null;
            }
            case EntryType.SHORT -> {
                ShortRange range = entry.field().getAnnotation(ShortRange.class);
                if (range != null) {
                    yield LongLongPair.of((long)range.min(), (long)range.max());
                }
                yield null;
            }
            case EntryType.INTEGER -> {
                IntRange range = entry.field().getAnnotation(IntRange.class);
                if (range != null) {
                    yield LongLongPair.of((long)range.min(), (long)range.max());
                }
                yield null;
            }
            case EntryType.LONG -> {
                LongRange range = entry.field().getAnnotation(LongRange.class);
                if (range != null) {
                    yield LongLongPair.of((long)range.min(), (long)range.max());
                }
                yield null;
            }
            default -> throw new IllegalArgumentException("Entry is not an integer!");
        };
    }
}

