/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.mutable.MutableObject;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.Identifiers;
import snownee.jade.api.callback.JadeBeforeRenderCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.TooltipRect;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.impl.ui.BoxElement;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.ModIdentification;

public class OverlayRenderer {
    public static final MutableObject<Theme> theme = new MutableObject((Object)IWailaConfig.get().getOverlay().getTheme());
    public static final TooltipRect rect = new TooltipRect();
    public static float ticks;
    public static boolean shown;
    public static float alpha;
    private static BoxElement lingerTooltip;
    private static float disappearTicks;

    public static boolean shouldShow() {
        if (WailaTickHandler.instance().rootElement == null) {
            return false;
        }
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (!general.shouldDisplayTooltip()) {
            return false;
        }
        if (general.getDisplayMode() == IWailaConfig.DisplayMode.HOLD_KEY && !JadeClient.showOverlay.m_90857_()) {
            return false;
        }
        IWailaConfig.BossBarOverlapMode mode = Jade.CONFIG.get().getGeneral().getBossBarOverlapMode();
        return mode != IWailaConfig.BossBarOverlapMode.HIDE_TOOLTIP || ClientProxy.getBossBarRect() == null;
    }

    public static boolean shouldShowImmediately(BoxElement box) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return false;
        }
        if (!ClientProxy.shouldShowWithOverlay(mc, mc.f_91080_)) {
            return false;
        }
        box.updateExpectedRect(rect);
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        Screen screen = mc.f_91080_;
        if (screen instanceof PreviewOptionsScreen) {
            double y;
            PreviewOptionsScreen optionsScreen = (PreviewOptionsScreen)screen;
            if (optionsScreen.forcePreviewOverlay()) {
                return true;
            }
            if (!general.previewOverlay) {
                return false;
            }
            Window window = mc.m_91268_();
            double x = mc.f_91067_.m_91589_() * (double)window.m_85445_() / (double)window.m_85443_();
            if (OverlayRenderer.rect.expectedRect.m_110087_((int)x, (int)(y = mc.f_91067_.m_91594_() * (double)window.m_85446_() / (double)window.m_85444_()))) {
                return false;
            }
        }
        if (mc.f_91065_.m_295051_().m_294516_() && general.shouldHideFromDebug()) {
            return false;
        }
        if (mc.m_91265_() != null || mc.f_91066_.f_92062_) {
            return false;
        }
        return !mc.f_91065_.m_93088_().f_94524_ || !general.shouldHideFromTabList();
    }

    public static void renderOverlay478757(GuiGraphics guiGraphics) {
        boolean show;
        float delta = Minecraft.m_91087_().m_91297_();
        ticks += delta;
        shown = false;
        BoxElement root = WailaTickHandler.instance().rootElement;
        if (root == null && PreviewOptionsScreen.isAdjustingPosition()) {
            Tooltip tooltip = new Tooltip();
            tooltip.add((Component)IThemeHelper.get().title(Blocks.f_50440_.m_49954_()));
            tooltip.add((Component)IThemeHelper.get().modName(ModIdentification.getModName(Blocks.f_50440_)));
            root = new BoxElement(tooltip, IThemeHelper.get().theme().tooltipStyle);
            root.tag(Identifiers.ROOT);
            root.setThemeIcon(ItemStackElement.of(new ItemStack((ItemLike)Blocks.f_50440_)), IThemeHelper.get().theme());
            root.updateExpectedRect(rect);
            show = true;
        } else {
            show = OverlayRenderer.shouldShow();
        }
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (root != null) {
            lingerTooltip = root;
        }
        if (root == null && lingerTooltip != null) {
            if ((disappearTicks += delta) < overlay.getDisappearingDelay()) {
                root = lingerTooltip;
                show = true;
            }
        } else {
            disappearTicks = 0.0f;
        }
        if (overlay.getAnimation() && lingerTooltip != null) {
            root = lingerTooltip;
            float speed = general.isDebug() ? 0.1f : 0.6f;
            alpha += (show ? speed : -speed) * delta;
            alpha = Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f);
        } else {
            float f = alpha = show ? 1.0f : 0.0f;
        }
        if (!(!(alpha < 0.1f) && root != null && OverlayRenderer.shouldShowImmediately(root) || PreviewOptionsScreen.isAdjustingPosition())) {
            lingerTooltip = null;
            OverlayRenderer.rect.rect.m_173056_(0);
            WailaTickHandler.clearLastNarration();
            return;
        }
        Minecraft.m_91087_().m_91307_().m_6180_("Jade Overlay");
        OverlayRenderer.renderOverlay(root, guiGraphics);
        Minecraft.m_91087_().m_91307_().m_7238_();
    }

    public static void renderOverlay(BoxElement root, GuiGraphics guiGraphics) {
        root.updateRect(rect);
        for (JadeBeforeRenderCallback callback2 : WailaClientRegistration.instance().beforeRenderCallback.callbacks()) {
            if (!callback2.beforeRender(root, rect, guiGraphics, ObjectDataCenter.get())) continue;
            return;
        }
        PoseStack matrixStack = guiGraphics.m_280168_();
        matrixStack.m_85836_();
        float z = Minecraft.m_91087_().f_91080_ == null ? 1.0f : 100.0f;
        matrixStack.m_252880_((float)OverlayRenderer.rect.rect.m_110085_(), (float)OverlayRenderer.rect.rect.m_110086_(), z);
        float scale = OverlayRenderer.rect.scale;
        if (scale != 1.0f) {
            matrixStack.m_85841_(scale, scale, 1.0f);
        }
        RenderSystem.enableBlend();
        float maxWidth = OverlayRenderer.rect.rect.m_110090_();
        float maxHeight = OverlayRenderer.rect.rect.m_110091_();
        if (root.getStyle().hasRoundCorner()) {
            maxWidth -= 2.0f;
            maxHeight -= 2.0f;
        }
        root.render(guiGraphics, 0.0f, 0.0f, maxWidth /= scale, maxHeight /= scale);
        WailaClientRegistration.instance().afterRenderCallback.call(callback -> callback.afterRender(root, rect, guiGraphics, ObjectDataCenter.get()));
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        matrixStack.m_85849_();
        if (Jade.CONFIG.get().getGeneral().shouldEnableTextToSpeech()) {
            WailaTickHandler.narrate(root.getTooltip(), true);
        }
        shown = true;
    }
}

