/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Identifiers;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.overlay.DisplayHelper;

public class HealthElement
extends Element {
    public static final ResourceLocation HEART = new ResourceLocation("hud/heart/full");
    public static final ResourceLocation HALF_HEART = new ResourceLocation("hud/heart/half");
    public static final ResourceLocation EMPTY_HEART = new ResourceLocation("hud/heart/container");
    private final float maxHealth;
    private final float health;
    private final String text;

    public HealthElement(float maxHealth, float health) {
        if (!PluginConfig.INSTANCE.get(Identifiers.MC_ENTITY_HEALTH_SHOW_FRACTIONS)) {
            maxHealth = Mth.m_14167_((float)maxHealth);
            health = Mth.m_14167_((float)health);
        }
        this.maxHealth = maxHealth;
        this.health = health;
        this.text = String.format("  %s/%s", DisplayHelper.dfCommas.format(health), DisplayHelper.dfCommas.format(maxHealth));
    }

    @Override
    public Vec2 getSize() {
        if (this.maxHealth > (float)PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_MAX_FOR_RENDER)) {
            Font font = Minecraft.m_91087_().f_91062_;
            return new Vec2((float)(9 + font.m_92895_(this.text)), 10.0f);
        }
        float maxHearts = PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_ICONS_PER_LINE);
        float maxHealth = this.maxHealth * 0.5f;
        int heartsPerLine = (int)Math.min((double)maxHearts, Math.ceil(maxHealth));
        int lineCount = (int)Math.ceil(maxHealth / maxHearts);
        return new Vec2((float)(9 * heartsPerLine), (float)(10 * lineCount));
    }

    @Override
    public void render(GuiGraphics guiGraphics, float x, float y, float maxX, float maxY) {
        float maxHearts = PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_ICONS_PER_LINE);
        int maxHeartsForRender = PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_MAX_FOR_RENDER);
        boolean showNumbers = this.maxHealth > (float)maxHeartsForRender;
        int heartCount = showNumbers ? 1 : Mth.m_14167_((float)(this.maxHealth * 0.5f));
        float health = showNumbers ? 1.0f : this.health * 0.5f;
        int heartsPerLine = (int)Math.min((double)maxHearts, Math.ceil(this.maxHealth));
        IDisplayHelper helper = IDisplayHelper.get();
        int xOffset = 0;
        for (int i = 1; i <= heartCount; ++i) {
            helper.blitSprite(guiGraphics, EMPTY_HEART, (int)(x + (float)xOffset), (int)y, 9, 9);
            if (i <= Mth.m_14143_((float)health)) {
                helper.blitSprite(guiGraphics, HEART, (int)(x + (float)xOffset), (int)y, 9, 9);
            }
            if ((float)i > health && (float)i < health + 1.0f) {
                helper.blitSprite(guiGraphics, HALF_HEART, (int)(x + (float)xOffset), (int)y, 9, 9);
            }
            xOffset += 9;
            if (showNumbers || i % heartsPerLine != 0) continue;
            y += 10.0f;
            xOffset = 0;
        }
        if (showNumbers) {
            helper.drawText(guiGraphics, this.text, x + 8.0f, y, IThemeHelper.get().getNormalColor());
        }
    }

    @Override
    @Nullable
    public String getMessage() {
        return I18n.m_118938_((String)"narration.jade.health", (Object[])new Object[]{DisplayHelper.dfCommas.format(this.health)});
    }
}

