/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import snownee.jade.Jade;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.overlay.OverlayRenderer;

public abstract class PreviewOptionsScreen
extends BaseOptionsScreen {
    public boolean adjustingPosition;
    private boolean adjustDragging;
    private double dragOffsetX;
    private double dragOffsetY;

    public PreviewOptionsScreen(Screen parent, Component title) {
        super(parent, title);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAdjustingPosition() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (!(screen instanceof PreviewOptionsScreen)) return false;
        PreviewOptionsScreen screen2 = (PreviewOptionsScreen)screen;
        if (!screen2.adjustingPosition) return false;
        return true;
    }

    private static float calculateAnchor(float center, float size) {
        float anchor = center / size;
        if (anchor < 0.25f) {
            return 0.0f;
        }
        if (anchor < 0.75f) {
            return 0.5f;
        }
        return 1.0f;
    }

    private static float maybeSnap(float value) {
        if (!Screen.m_96637_() && value > 0.475f && value < 0.525f) {
            return 0.5f;
        }
        return value;
    }

    @Override
    protected void m_7856_() {
        Objects.requireNonNull(this.f_96541_);
        super.m_7856_();
        if (this.f_96541_.f_91073_ != null) {
            CycleButton previewButton = CycleButton.m_168896_((Component)OptionsList.OPTION_ON, (Component)OptionsList.OPTION_OFF).m_168936_(10, this.saveButton.m_252907_(), 85, 20, (Component)Component.m_237115_((String)"gui.jade.preview"), (button, value) -> {
                Jade.CONFIG.get().getGeneral().previewOverlay = value;
                this.saver.run();
            });
            previewButton.m_168892_((Object)Jade.CONFIG.get().getGeneral().previewOverlay);
            this.m_142416_((GuiEventListener)previewButton);
        }
    }

    public boolean forcePreviewOverlay() {
        Objects.requireNonNull(this.f_96541_);
        if (this.adjustingPosition) {
            return true;
        }
        if (!this.m_7282_() || this.options == null) {
            return false;
        }
        OptionsList.Entry entry = (OptionsList.Entry)this.options.m_93511_();
        if (entry == null || entry.getFirstWidget() == null) {
            return false;
        }
        return this.options.forcePreview.contains((Object)entry);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int p_94697_) {
        if (this.adjustingPosition) {
            Objects.requireNonNull(this.f_96541_);
            Rect2i rect = OverlayRenderer.rect.expectedRect;
            if (rect.m_110087_((int)mouseX, (int)mouseY)) {
                this.m_7897_(true);
                this.adjustDragging = true;
                float centerX = (float)rect.m_110085_() + (float)rect.m_110090_() / 2.0f;
                float centerY = (float)rect.m_110086_() + (float)rect.m_110091_() / 2.0f;
                this.dragOffsetX = mouseX - (double)centerX;
                this.dragOffsetY = mouseY - (double)centerY;
                return true;
            }
            this.adjustingPosition = false;
            this.adjustDragging = false;
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        return super.m_6375_(mouseX, mouseY, p_94697_);
    }

    public boolean m_6348_(double d, double e, int i) {
        if (this.adjustingPosition) {
            this.m_7897_(false);
            this.adjustDragging = false;
            return true;
        }
        return super.m_6348_(d, e, i);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.adjustingPosition) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean m_7933_(int i, int j, int k) {
        if (this.adjustingPosition) {
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    public boolean m_7920_(int i, int j, int k) {
        Objects.requireNonNull(this.f_96541_);
        if (this.adjustingPosition) {
            if (i == 256) {
                this.adjustingPosition = false;
                this.adjustDragging = false;
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            }
            return true;
        }
        return super.m_7920_(i, j, k);
    }

    public boolean m_7979_(double d, double e, int i, double f, double g) {
        if (this.adjustingPosition && this.adjustDragging) {
            float centerX = (float)d - (float)this.dragOffsetX;
            float centerY = (float)e - (float)this.dragOffsetY;
            float anchorX = PreviewOptionsScreen.calculateAnchor(centerX, this.f_96543_);
            float anchorY = PreviewOptionsScreen.calculateAnchor(centerY, this.f_96544_);
            Rect2i rect = OverlayRenderer.rect.expectedRect;
            float posX = (centerX + (float)rect.m_110090_() * (anchorX - 0.5f)) / (float)this.f_96543_;
            float posY = 1.0f - (centerY + (float)rect.m_110091_() * (anchorY - 0.5f)) / (float)this.f_96544_;
            IWailaConfig.IConfigOverlay config = IWailaConfig.get().getOverlay();
            config.setOverlayPosX(config.tryFlip(PreviewOptionsScreen.maybeSnap(posX)));
            config.setOverlayPosY(PreviewOptionsScreen.maybeSnap(posY));
            config.setAnchorX(config.tryFlip(anchorX));
            config.setAnchorY(anchorY);
            return true;
        }
        return super.m_7979_(d, e, i, f, g);
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.adjustingPosition) {
            guiGraphics.m_280046_(0, 0, this.f_96543_, this.f_96544_, 50, -2136298838);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 50.0f);
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"config.jade.overlay_pos.exit"), this.f_96543_ / 2, this.f_96544_ / 2 - 7, 0xFFFFFF);
            guiGraphics.m_280168_().m_85849_();
            IWailaConfig.IConfigOverlay config = IWailaConfig.get().getOverlay();
            Rect2i rect = OverlayRenderer.rect.expectedRect;
            if (IWailaConfig.get().getGeneral().isDebug()) {
                int anchorX = (int)((float)rect.m_110085_() + (float)rect.m_110090_() * config.getAnchorX());
                int anchorY = (int)((float)rect.m_110086_() + (float)rect.m_110091_() * config.getAnchorY());
                guiGraphics.m_280046_(anchorX - 2, anchorY - 2, anchorX + 1, anchorY + 1, 1000, -65536);
            }
            if (config.getOverlayPosX() == 0.5f) {
                guiGraphics.m_280046_(this.f_96543_ / 2, rect.m_110086_() - 5, this.f_96543_ / 2 + 1, rect.m_110086_() + rect.m_110091_() + 4, 1000, -16776961);
            }
            if (config.getOverlayPosY() == 0.5f) {
                guiGraphics.m_280046_(rect.m_110085_() - 5, this.f_96544_ / 2, rect.m_110085_() + rect.m_110090_() + 4, this.f_96544_ / 2 + 1, 1000, -16776961);
            }
            this.f_262730_ = null;
        }
    }
}

