/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import snownee.jade.Jade;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.gui.JadeFont;
import snownee.jade.gui.PluginsConfigScreen;
import snownee.jade.gui.WailaConfigScreen;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.util.ModIdentification;
import snownee.jade.util.SmoothChasingValue;

public class HomeConfigScreen
extends Screen {
    private final RandomSource random = RandomSource.m_216335_((long)42L);
    private final Screen parent;
    private final SmoothChasingValue titleY;
    private final SmoothChasingValue creditHover;
    private final Component credit;
    private final List<TextParticle> particles = Lists.newArrayList();
    private int creditWidth;
    private boolean hovered;
    private float ticks;
    private byte festival;

    public HomeConfigScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"gui.jade.configuration"));
        this.parent = parent;
        this.titleY = new SmoothChasingValue().start(8.0f).target(32.0f).withSpeed(0.1f);
        this.creditHover = new SmoothChasingValue();
        LocalDate now = LocalDate.now();
        int month = now.getMonthValue();
        int day = now.getDayOfMonth();
        if (month == 12 && day >= 24 && day <= 26) {
            this.festival = 1;
        } else if (month == 6 && day == 28) {
            this.festival = (byte)2;
        } else {
            Int2IntOpenHashMap newyears = new Int2IntOpenHashMap();
            newyears.put(2024, 210);
            newyears.put(2025, 129);
            newyears.put(2026, 217);
            newyears.put(2027, 206);
            newyears.put(2028, 126);
            newyears.put(2029, 213);
            newyears.put(2030, 203);
            newyears.put(2031, 123);
            newyears.put(2032, 211);
            newyears.put(2033, 131);
            newyears.put(2034, 219);
            newyears.put(2035, 208);
            newyears.put(2036, 128);
            newyears.put(2037, 215);
            newyears.put(2038, 204);
            newyears.put(2039, 124);
            newyears.put(2040, 212);
            newyears.put(2041, 201);
            newyears.put(2042, 122);
            newyears.put(2043, 210);
            int year = now.getYear();
            if (newyears.containsKey(year)) {
                int newyearMonth = newyears.get(year) / 100;
                int newyearDay = newyears.get(year) % 100;
                LocalDate newyearDate = LocalDate.of(year, newyearMonth, newyearDay);
                int newyearDayofyear = newyearDate.getDayOfYear();
                int dayofyear = now.getDayOfYear();
                if (dayofyear >= newyearDayofyear - 1 && dayofyear <= newyearDayofyear + 2) {
                    this.festival = (byte)99;
                }
            }
        }
        this.credit = Component.m_237110_((String)"gui.jade.by", (Object[])new Object[]{Component.m_237113_((String)"\u2764").m_130940_(ChatFormatting.RED)}).m_130938_(s -> {
            if (this.festival != 0) {
                s = s.m_178520_(15852452);
            }
            return s;
        });
    }

    protected void m_7856_() {
        Objects.requireNonNull(this.f_96541_);
        this.particles.clear();
        this.creditWidth = this.f_96547_.m_92852_((FormattedText)this.credit);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.jade.jade_settings"), w -> this.f_96541_.m_91152_((Screen)new WailaConfigScreen(this))).m_252987_(this.f_96543_ / 2 - 105, this.f_96544_ / 2 - 10, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.jade.plugin_settings"), w -> this.f_96541_.m_91152_((Screen)new PluginsConfigScreen(this))).m_252987_(this.f_96543_ / 2 + 5, this.f_96544_ / 2 - 10, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, w -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 50, this.f_96544_ / 2 + 20, 100, 20).m_253136_());
    }

    public void m_7379_() {
        Jade.CONFIG.save();
        PluginConfig.INSTANCE.save();
        Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        boolean hover;
        float scaledY;
        float scaledX;
        Objects.requireNonNull(this.f_96541_);
        this.ticks += partialTicks;
        this.m_280273_(guiGraphics, x, y, partialTicks);
        boolean smallUI = this.f_96541_.m_91268_().m_85449_() < 3.0;
        int left = this.f_96543_ / 2 - 105;
        int top = this.f_96544_ / 4 - 20;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)left, (float)top, 0.0f);
        float scale = smallUI ? 2.0f : 1.5f;
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        guiGraphics.m_280488_(this.f_96547_, ModIdentification.getModName("jade").orElse("Jade"), 0, 0, 0xFFFFFF);
        guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        this.titleY.tick(partialTicks);
        String desc2 = I18n.m_118938_((String)"gui.jade.configuration.desc2", (Object[])new Object[0]);
        if (desc2.isEmpty()) {
            guiGraphics.m_280168_().m_85849_();
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)left, (float)top, 0.0f);
            scaledX = x - left;
            scaledY = y - top;
        } else {
            scaledX = (float)(x - left) / scale * 2.0f;
            scaledY = (float)(y - top) / scale * 2.0f;
        }
        this.drawFancyTitle(guiGraphics, I18n.m_118938_((String)"gui.jade.configuration.desc1", (Object[])new Object[0]), Math.min(this.titleY.value, 20.0f), 20.0f, scaledX, scaledY);
        if (!desc2.isEmpty()) {
            this.drawFancyTitle(guiGraphics, desc2, this.titleY.value, 32.0f, scaledX, scaledY);
        }
        guiGraphics.m_280168_().m_85849_();
        super.m_88315_(guiGraphics, x, y, partialTicks);
        int creditX = (int)((float)this.f_96543_ * 0.5f - (float)this.creditWidth * 0.5f);
        int creditY = (int)((float)this.f_96544_ * 0.9f - 5.0f);
        boolean bl = hover = x >= creditX && x < creditX + this.creditWidth && y >= creditY && y < creditY + 10;
        if (!this.hovered && hover) {
            this.creditHover.target(1.0f);
        } else if (!hover) {
            this.creditHover.target(0.0f);
        } else if ((double)this.creditHover.value > 0.5) {
            this.creditHover.target(0.0f);
            IntArrayList colors = new IntArrayList();
            String text = "\u2744";
            if (this.festival == 2) {
                for (int i = 0; i < 11; ++i) {
                    colors.add(Mth.m_14169_((float)this.random.m_188501_(), (float)0.8f, (float)0.9f));
                }
                text = "\u2764";
            } else if (this.festival == 1) {
                IntList palette = IntList.of((int[])new int[]{14083301, 14083301, 0xEFF5F5, 0xEFF5F5, 4813172, 15426624});
                for (int i = 0; i < 11; ++i) {
                    colors.add(palette.getInt(this.random.m_188503_(palette.size())));
                }
            } else if (this.festival == 99) {
                for (int i = 0; i < 11; ++i) {
                    colors.add(this.random.m_188499_() ? 0xA80000 : 12589056);
                }
                text = "\u2710";
            } else {
                for (int i = 0; i < 11; ++i) {
                    colors.add(Mth.m_14159_((float)(1.0f - this.random.m_188501_() * 0.6f), (float)1.0f, (float)1.0f));
                }
            }
            IntListIterator intListIterator = colors.iterator();
            while (intListIterator.hasNext()) {
                int color = (Integer)intListIterator.next();
                int ox = this.random.m_216332_(-this.creditWidth / 2, this.creditWidth / 2);
                TextParticle particle = new TextParticle(text, (float)this.f_96543_ * 0.5f + (float)ox, creditY + this.random.m_188503_(10), (float)ox * 0.08f, -5.0f - this.random.m_188501_() * 3.0f, color, 0.75f + this.random.m_188501_() * 0.5f);
                this.particles.add(particle);
                if (this.festival != 99) continue;
                particle.age = 8.0f + this.random.m_188501_() * 5.0f;
            }
        }
        this.creditHover.tick(partialTicks);
        this.creditHover.value = Math.min(0.6f, this.creditHover.value);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.f_96543_ * 0.5f, (float)creditY, 0.0f);
        scale = 1.0f + this.creditHover.value * 0.2f;
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        guiGraphics.m_280168_().m_252880_((float)this.creditWidth * -0.5f, 0.0f, 0.0f);
        guiGraphics.m_280430_(this.f_96547_, this.credit, 0, 0, 0x55FFFFFF);
        guiGraphics.m_280168_().m_85849_();
        this.hovered = hover;
        this.particles.removeIf(p -> {
            p.tick(partialTicks);
            if (p.y > (float)this.f_96544_) {
                return true;
            }
            p.render(guiGraphics, this.f_96547_);
            return false;
        });
    }

    private void drawFancyTitle(GuiGraphics guiGraphics, String text, float y, float expectY, float mouseX, float mouseY) {
        float distY = Math.abs(y - expectY);
        if (distY >= 9.0f) {
            return;
        }
        int color = IWailaConfig.IConfigOverlay.applyAlpha(0xAAAAAA, 1.0f - distY / 10.0f);
        ((JadeFont)this.f_96547_).jade$setGlint((this.ticks - y / 5.0f) % 90.0f / 45.0f * (float)this.f_96543_, mouseX);
        ((JadeFont)this.f_96547_).jade$setGlintStrength(1.0f, 1.0f - Mth.m_14036_((float)(Math.abs(mouseY - y) / 20.0f), (float)0.0f, (float)1.0f));
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, y, 0.0f);
        guiGraphics.m_280488_(this.f_96547_, text, 0, 0, color);
        guiGraphics.m_280168_().m_85849_();
        ((JadeFont)this.f_96547_).jade$setGlint(Float.NaN, Float.NaN);
    }

    private class TextParticle {
        private float age;
        private String text;
        private float x;
        private float y;
        private float motionX;
        private float motionY;
        private int color;
        private float scale;

        public TextParticle(String text, float x, float y, float motionX, float motionY, int color, float scale) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.motionX = motionX;
            this.motionY = motionY;
            this.color = color;
            this.scale = scale;
        }

        private void tick(float partialTicks) {
            this.x += this.motionX * partialTicks;
            this.y += this.motionY * partialTicks;
            this.motionY += 0.98f * partialTicks;
            if (HomeConfigScreen.this.festival == 99) {
                boolean geaterThanZero = this.age > 0.0f;
                this.age -= partialTicks;
                if (geaterThanZero && this.age <= 0.0f) {
                    this.text = HomeConfigScreen.this.random.m_188499_() ? "\u2734" : "\u2733";
                    this.color = HomeConfigScreen.this.random.m_188499_() ? 16765991 : 15778837;
                    Objects.requireNonNull(HomeConfigScreen.this.f_96541_);
                    HomeConfigScreen.this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)(HomeConfigScreen.this.random.m_188499_() ? SoundEvents.f_11928_ : SoundEvents.f_11930_), (float)0.7f));
                }
            }
        }

        private void render(GuiGraphics guiGraphics, Font font) {
            if (HomeConfigScreen.this.festival == 99 && this.age < -4.0f) {
                return;
            }
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(this.x, this.y, 0.0f);
            guiGraphics.m_280168_().m_85841_(this.scale, this.scale, this.scale);
            guiGraphics.m_280488_(font, this.text, 0, 0, this.color);
            guiGraphics.m_280168_().m_85849_();
        }
    }
}

