/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import org.apache.commons.lang3.mutable.MutableBoolean;
import snownee.jade.addon.universal.ItemCollector;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.Direction2D;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.ui.HorizontalLineElement;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public enum ItemStorageProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>,
IServerExtensionProvider<Object, ItemStack>,
IClientExtensionProvider<ItemStack, ItemView>
{
    INSTANCE;

    public final Cache<Object, ItemCollector<?>> targetCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(60L, TimeUnit.SECONDS).build();
    public final Cache<Object, ItemCollector<?>> containerCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(120L, TimeUnit.SECONDS).build();

    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        if (!accessor.getServerData().m_128441_("JadeItemStorage")) {
            if (accessor.getServerData().m_128471_("Loot")) {
                tooltip.add((Component)Component.m_237115_((String)"jade.loot_not_generated"));
            } else if (accessor.getServerData().m_128471_("Locked")) {
                tooltip.add((Component)Component.m_237115_((String)"jade.locked"));
            }
            return;
        }
        Optional<IClientExtensionProvider> provider = Optional.ofNullable(ResourceLocation.m_135820_((String)accessor.getServerData().m_128461_("JadeItemStorageUid"))).map(WailaClientRegistration.instance().itemStorageProviders::get);
        if (provider.isEmpty()) {
            return;
        }
        List groups = provider.get().getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeItemStorage", itemTag -> {
            ItemStack item = ItemStack.m_41712_((CompoundTag)itemTag);
            if (!item.m_41619_() && itemTag.m_128441_("NewCount")) {
                item.m_41764_(itemTag.m_128451_("NewCount"));
            }
            return item;
        }));
        if (groups.isEmpty()) {
            return;
        }
        MutableBoolean showName = new MutableBoolean(true);
        int totalSize = 0;
        for (ClientViewGroup clientViewGroup : groups) {
            for (ItemView view : clientViewGroup.views) {
                if (view.amountText != null) {
                    showName.setFalse();
                }
                if (view.item.m_41619_()) continue;
                ++totalSize;
            }
        }
        if (showName.isTrue()) {
            showName.setValue(totalSize < PluginConfig.INSTANCE.getInt(Identifiers.MC_ITEM_STORAGE_SHOW_NAME_AMOUNT));
        }
        IElementHelper helper = IElementHelper.get();
        boolean renderGroup = groups.size() > 1 || groups.get(0).shouldRenderGroup();
        ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
            float progress;
            CompoundTag data;
            if (renderGroup) {
                theTooltip.add(new HorizontalLineElement());
                if (group.title != null) {
                    theTooltip.append(helper.text(group.title).scale(0.5f));
                    theTooltip.append(new HorizontalLineElement());
                }
            }
            if (group.views.isEmpty() && (data = group.extraData) != null && data.m_128425_("Collecting", 99) && (progress = data.m_128457_("Collecting")) < 1.0f) {
                MutableComponent component = Component.m_237115_((String)"jade.collectingItems");
                if (progress > 0.0f) {
                    component.m_130946_(" %s%%".formatted((int)(progress * 100.0f)));
                }
                theTooltip.add((Component)component);
            }
            int drawnCount = 0;
            int realSize = PluginConfig.INSTANCE.getInt(accessor.showDetails() ? Identifiers.MC_ITEM_STORAGE_DETAILED_AMOUNT : Identifiers.MC_ITEM_STORAGE_NORMAL_AMOUNT);
            realSize = Math.min(group.views.size(), realSize);
            ArrayList elements = Lists.newArrayList();
            for (int i = 0; i < realSize; ++i) {
                ItemView itemView = (ItemView)group.views.get(i);
                ItemStack stack = itemView.item;
                if (stack.m_41619_()) continue;
                if (i > 0 && (showName.isTrue() || drawnCount >= PluginConfig.INSTANCE.getInt(Identifiers.MC_ITEM_STORAGE_ITEMS_PER_LINE))) {
                    theTooltip.add(elements);
                    theTooltip.setLineMargin(-1, Direction2D.DOWN, -1);
                    elements.clear();
                    drawnCount = 0;
                }
                if (showName.isTrue()) {
                    if (itemView.description != null) {
                        elements.add(helper.smallItem(stack));
                        elements.addAll(itemView.description);
                    } else {
                        elements.add(helper.smallItem(stack).clearCachedMessage());
                        elements.add(helper.text((Component)Component.m_237113_((String)IDisplayHelper.get().humanReadableNumber(stack.m_41613_(), "", false, null)).m_130946_("\u00d7 ").m_7220_((Component)IDisplayHelper.get().stripColor(stack.m_41786_()))).message(null));
                    }
                } else if (itemView.amountText != null) {
                    elements.add(helper.item(stack, 1.0f, itemView.amountText));
                } else {
                    elements.add(helper.item(stack));
                }
                ++drawnCount;
            }
            if (!elements.isEmpty()) {
                theTooltip.add(elements);
            }
        });
    }

    public static void putData(Accessor<?> accessor) {
        CompoundTag tag = accessor.getServerData();
        Object target = accessor.getTarget();
        Player player = accessor.getPlayer();
        for (IServerExtensionProvider<Object, ItemStack> provider : WailaCommonRegistration.instance().itemStorageProviders.get(target)) {
            RandomizableContainer containerEntity;
            List groups = provider.getGroups(accessor, target);
            if (groups == null) continue;
            if (ViewGroup.saveList(tag, "JadeItemStorage", groups, item -> {
                CompoundTag itemTag = new CompoundTag();
                int count = item.m_41613_();
                if (count > 64) {
                    item.m_41764_(1);
                }
                item.m_41739_(itemTag);
                if (count > 64) {
                    itemTag.m_128405_("NewCount", count);
                    item.m_41764_(count);
                }
                return itemTag;
            })) {
                tag.m_128359_("JadeItemStorageUid", provider.getUid().toString());
                break;
            }
            if (target instanceof RandomizableContainer && (containerEntity = (RandomizableContainer)target).m_305426_() != null) {
                tag.m_128379_("Loot", true);
                break;
            }
            if (player.m_7500_() || player.m_5833_() || !(target instanceof BaseContainerBlockEntity)) break;
            BaseContainerBlockEntity te = (BaseContainerBlockEntity)target;
            if (te.f_58621_ == LockCode.f_19102_) break;
            tag.m_128379_("Locked", true);
            break;
        }
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlockEntity() instanceof AbstractFurnaceBlockEntity) {
            return;
        }
        ItemStorageProvider.append(tooltip, accessor, config);
    }

    @Override
    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        if (accessor.getBlockEntity() instanceof AbstractFurnaceBlockEntity) {
            return;
        }
        ItemStorageProvider.putData(accessor);
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.UNIVERSAL_ITEM_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    public List<ViewGroup<ItemStack>> getGroups(Accessor<?> accessor, Object target) {
        ItemCollector itemCollector;
        ContainerEntity containerEntity;
        RandomizableContainer te;
        if (target instanceof RandomizableContainer && (te = (RandomizableContainer)target).m_305426_() != null) {
            return List.of();
        }
        if (target instanceof ContainerEntity && (containerEntity = (ContainerEntity)target).m_214142_() != null) {
            return List.of();
        }
        Player player = accessor.getPlayer();
        if (!player.m_7500_() && !player.m_5833_() && target instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity te2 = (BaseContainerBlockEntity)target;
            if (te2.f_58621_ != LockCode.f_19102_) {
                return List.of();
            }
        }
        if (player != null && target instanceof EnderChestBlockEntity) {
            PlayerEnderChestContainer inventory = player.m_36327_();
            return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(0)).update(inventory, accessor.getLevel().m_46467_());
        }
        try {
            itemCollector = (ItemCollector)this.targetCache.get(target, () -> CommonProxy.createItemCollector(target, this.containerCache));
        }
        catch (ExecutionException e) {
            WailaExceptionHandler.handleErr(e, null, null);
            return null;
        }
        if (itemCollector == ItemCollector.EMPTY) {
            return null;
        }
        return itemCollector.update(target, accessor.getLevel().m_46467_());
    }

    @Override
    public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<ItemStack>> groups) {
        return ClientViewGroup.map(groups, ItemView::new, null);
    }
}

