/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ProgressStyle;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.CommonProxy;

public enum EnergyStorageProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>,
IServerExtensionProvider<Object, CompoundTag>,
IClientExtensionProvider<CompoundTag, EnergyView>
{
    INSTANCE;


    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        if (!accessor.showDetails() && config.get(Identifiers.UNIVERSAL_ENERGY_STORAGE_DETAILED)) {
            return;
        }
        if (accessor.getServerData().m_128441_("JadeEnergyStorage")) {
            Optional<IClientExtensionProvider> provider = Optional.ofNullable(ResourceLocation.m_135820_((String)accessor.getServerData().m_128461_("JadeEnergyStorageUid"))).map(WailaClientRegistration.instance().energyStorageProviders::get);
            if (provider.isPresent()) {
                List groups = provider.get().getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeEnergyStorage", Function.identity()));
                if (groups.isEmpty()) {
                    return;
                }
                IElementHelper helper = IElementHelper.get();
                boolean renderGroup = groups.size() > 1 || groups.get(0).shouldRenderGroup();
                ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
                    if (renderGroup) {
                        group.renderHeader((ITooltip)theTooltip);
                    }
                    for (EnergyView view : group.views) {
                        Object text = view.overrideText != null ? view.overrideText : Component.m_237110_((String)"jade.fe", (Object[])new Object[]{ChatFormatting.WHITE + view.current, view.max}).m_130940_(ChatFormatting.GRAY);
                        ProgressStyle progressStyle = helper.progressStyle().color(-5636096, -10092544);
                        theTooltip.add(helper.progress(view.ratio, (Component)text, progressStyle, BoxStyle.getNestedBox(), true));
                    }
                });
            }
        }
    }

    public static void putData(Accessor<?> accessor) {
        CompoundTag tag = accessor.getServerData();
        Object target = accessor.getTarget();
        for (IServerExtensionProvider<Object, CompoundTag> provider : WailaCommonRegistration.instance().energyStorageProviders.get(target)) {
            List groups = provider.getGroups(accessor, target);
            if (groups == null) continue;
            if (ViewGroup.saveList(tag, "JadeEnergyStorage", groups, Function.identity())) {
                tag.m_128359_("JadeEnergyStorageUid", provider.getUid().toString());
            }
            return;
        }
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        EnergyStorageProvider.append(tooltip, accessor, config);
    }

    @Override
    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        EnergyStorageProvider.putData(accessor);
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.UNIVERSAL_ENERGY_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    public List<ClientViewGroup<EnergyView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<CompoundTag>> groups) {
        return groups.stream().map($ -> {
            String unit = $.getExtraData().m_128461_("Unit");
            return new ClientViewGroup<EnergyView>($.views.stream().map(tag -> EnergyView.read(tag, unit)).filter(Objects::nonNull).toList());
        }).toList();
    }

    @Override
    public List<ViewGroup<CompoundTag>> getGroups(Accessor<?> accessor, Object target) {
        return CommonProxy.wrapEnergyStorage(accessor, target);
    }
}

