/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_neoforge.util;

import com.natamus.collective_common_neoforge.functions.DataFunctions;
import com.natamus.collective_common_neoforge.functions.ItemFunctions;
import com.natamus.collective_common_neoforge.functions.NumberFunctions;
import com.natamus.collective_common_neoforge.functions.PlayerFunctions;
import com.natamus.starterkit_common_neoforge.config.ConfigHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class Util {
    public static String startergearstring = "";
    private static final String dirpath = DataFunctions.getConfigDirectory() + File.separator + "starterkit";

    public static void getOrCreateGearConfig(boolean first) throws IOException {
        File dir = new File(dirpath);
        File file = new File(dirpath + File.separator + "starterkit.txt");
        if (dir.isDirectory() && file.isFile()) {
            String configstring = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "starterkit.txt", new String[0])), StandardCharsets.UTF_8);
            if (configstring.startsWith("'")) {
                startergearstring = configstring;
            } else {
                HashMap<String, ItemStack> simplegear = new HashMap<String, ItemStack>();
                for (String line : configstring.split(",")) {
                    Item item;
                    String[] itemspl;
                    String[] linespl = line.replace(" ", "").trim().split(":\"");
                    if (linespl.length < 2) continue;
                    int amount = 1;
                    String slotstring = linespl[0].replace("\"", "").trim();
                    String itemstring = linespl[1].replace("\"", "").trim();
                    if (itemstring.contains("-") && (itemspl = itemstring.split("-")).length > 1) {
                        itemstring = itemspl[0];
                        if (NumberFunctions.isNumeric((String)itemspl[1])) {
                            amount = Integer.parseInt(itemspl[1]);
                        }
                    }
                    ResourceLocation itemloc = new ResourceLocation(itemstring);
                    if (BuiltInRegistries.ITEM.keySet().contains(itemloc)) {
                        item = (Item)BuiltInRegistries.ITEM.get(itemloc);
                    } else {
                        if (!BuiltInRegistries.BLOCK.keySet().contains(itemloc)) continue;
                        Block block = (Block)BuiltInRegistries.BLOCK.get(itemloc);
                        item = block.asItem();
                    }
                    simplegear.put(slotstring, new ItemStack((ItemLike)item, amount));
                }
                startergearstring = PlayerFunctions.getPlayerGearStringFromHashMap(simplegear);
            }
        } else {
            dir.mkdirs();
            PrintWriter writer = new PrintWriter(dirpath + File.separator + "starterkit.txt", StandardCharsets.UTF_8);
            writer.println("'offhand' : '{Count:1b,id:\"minecraft:shield\",tag:{Damage:0}}',");
            writer.println("'head' : '',");
            writer.println("'chest' : '',");
            writer.println("'legs' : '',");
            writer.println("'feet' : '{Count:1b,id:\"minecraft:leather_boots\",tag:{Damage:0}}',");
            NonNullList emptyinventory = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
            for (int i = 0; i < emptyinventory.size(); ++i) {
                String itemstring = "";
                if (i == 0) {
                    itemstring = "{Count:1b,id:\"minecraft:wooden_sword\",tag:{Damage:0}}";
                } else if (i == 1) {
                    itemstring = "{Count:9b,id:\"minecraft:bread\"}";
                }
                writer.println(i + " : '" + itemstring + "',");
            }
            writer.close();
            if (first) {
                Util.getOrCreateGearConfig(false);
            }
        }
    }

    public static boolean createGearConfigFromGearString(String gearstring) throws IOException {
        File dir = new File(dirpath);
        File file = new File(dirpath + File.separator + "starterkit.txt");
        if (dir.isDirectory() && file.isFile()) {
            File renamedfile = new File(dirpath + File.separator + "starterkit-old.txt");
            int r = 0;
            while (renamedfile.exists()) {
                renamedfile = new File(dirpath + File.separator + "starterkit-old_" + r + ".txt");
                ++r;
            }
            file.renameTo(renamedfile);
        } else {
            dir.mkdirs();
        }
        PrintWriter writer = new PrintWriter(dirpath + File.separator + "starterkit.txt", StandardCharsets.UTF_8);
        writer.println(gearstring);
        writer.close();
        Util.getOrCreateGearConfig(false);
        return true;
    }

    public static void setStarterKit(Player player) {
        if (startergearstring.equals("")) {
            return;
        }
        ArrayList<ItemStack> toAddAfter = new ArrayList<ItemStack>();
        if (ConfigHandler.addExistingItemsAfterKitSet) {
            Inventory inv = player.getInventory();
            boolean isempty = true;
            for (int i = 0; i < 36; ++i) {
                ItemStack itemStack = inv.getItem(i);
                if (itemStack.isEmpty()) continue;
                toAddAfter.add(itemStack.copy());
            }
        }
        PlayerFunctions.setPlayerGearFromString((Player)player, (String)startergearstring);
        if (toAddAfter.size() > 0) {
            for (ItemStack itemStackToAdd : toAddAfter) {
                ItemFunctions.giveOrDropItemStack((Player)player, (ItemStack)itemStackToAdd);
            }
        }
    }

    public static boolean processNewGearString(String gearstring) {
        try {
            if (Util.createGearConfigFromGearString(gearstring)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

