/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_neoforge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_neoforge.functions.PlayerFunctions;
import com.natamus.collective_common_neoforge.functions.StringFunctions;
import com.natamus.starterkit_common_neoforge.util.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandStarterkit {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"starterkit").requires(iCommandSender -> iCommandSender.hasPermission(2))).then(Commands.literal((String)"set").executes(command -> {
            ServerPlayer player;
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            try {
                player = source.getPlayerOrException();
            }
            catch (CommandSyntaxException ex) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)"This command can only be executed as a player in-game.", (ChatFormatting)ChatFormatting.RED);
                return 1;
            }
            String newskconfig = PlayerFunctions.getPlayerGearString((Player)player);
            if (!Util.processNewGearString(newskconfig)) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)"Something went wrong while processing the new starterkit config.", (ChatFormatting)ChatFormatting.RED);
                return 0;
            }
            StringFunctions.sendMessage((CommandSourceStack)source, (String)"Starter Kit config updated. All new players will now receive your current inventory.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        })));
    }
}

