/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.scriptingexample.tests.helpers;

import org.junit.jupiter.api.Assertions;
import org.openzen.zencode.java.logger.ScriptingEngineStreamLogger;
import org.openzen.zenscript.scriptingexample.tests.helpers.ZenCodeTestLoggerOutput;

public class ZenCodeTestLogger
extends ScriptingEngineStreamLogger {
    private static final boolean logDebug = false;
    private final ZenCodeTestLoggerOutput printlnOutputs;
    private final ZenCodeTestLoggerOutput errors;
    private final ZenCodeTestLoggerOutput warnings;
    private boolean isEngineComplete = false;

    public ZenCodeTestLogger() {
        this.printlnOutputs = new ZenCodeTestLoggerOutput();
        this.errors = new ZenCodeTestLoggerOutput();
        this.warnings = new ZenCodeTestLoggerOutput();
    }

    public ZenCodeTestLogger(ZenCodeTestLoggerOutput printlnOutputs, ZenCodeTestLoggerOutput errors, ZenCodeTestLoggerOutput warnings) {
        this.printlnOutputs = printlnOutputs;
        this.errors = errors;
        this.warnings = warnings;
    }

    @Override
    public void debug(String message) {
    }

    @Override
    public void warning(String message) {
        this.warnings().add(message);
        super.warning(message);
    }

    @Override
    public void throwingWarn(String message, Throwable throwable) {
        this.warnings().add(message);
        super.throwingWarn(message, throwable);
    }

    public void logPrintln(String line) {
        this.info(line);
        this.printlnOutputs().add(line);
    }

    @Override
    public void error(String message) {
        this.errors().add(message);
        super.error(message);
    }

    @Override
    public void throwingErr(String message, Throwable throwable) {
        this.errors().add(message);
        super.throwingErr(message, throwable);
    }

    public void setEngineComplete() {
        this.isEngineComplete = true;
    }

    public void assertPrintOutput(int line, String content) {
        if (!this.isEngineComplete) {
            Assertions.fail((String)"Trying to call an assertion before the engine ran, probably a fault in the test!");
        }
        this.printlnOutputs().assertLine(line, content);
    }

    public void assertPrintOutputSize(int size) {
        if (!this.isEngineComplete) {
            Assertions.fail((String)"Trying to call an assertion before the engine ran, probably a fault in the test!");
        }
        this.printlnOutputs().assertSize(size);
    }

    public void assertNoErrors() {
        this.errors().assertEmpty();
    }

    public void assertNoWarnings() {
        this.warnings().assertEmpty();
    }

    public ZenCodeTestLoggerOutput printlnOutputs() {
        return this.printlnOutputs;
    }

    public ZenCodeTestLoggerOutput errors() {
        return this.errors;
    }

    public ZenCodeTestLoggerOutput warnings() {
        return this.warnings;
    }

    public boolean isEngineComplete() {
        return this.isEngineComplete;
    }
}

