/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.scriptingexample.tests.helpers;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.openzen.zencode.java.ScriptingEngine;
import org.openzen.zencode.java.module.JavaNativeModule;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.LiteralSourceFile;
import org.openzen.zencode.shared.SourceFile;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.SemanticModule;
import org.openzen.zenscript.codemodel.type.ArrayTypeID;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.scriptingexample.tests.SharedGlobals;
import org.openzen.zenscript.scriptingexample.tests.helpers.FunctionParameterList;
import org.openzen.zenscript.scriptingexample.tests.helpers.ZenCodeTestLogger;

public abstract class ZenCodeTest {
    protected final List<SourceFile> sourceFiles = new ArrayList<SourceFile>();
    protected ScriptingEngine engine;
    protected JavaNativeModule testModule;
    protected ZenCodeTestLogger logger;

    protected ZenCodeTest() {
    }

    @BeforeEach
    public void beforeEach() throws CompileException {
        this.logger = new ZenCodeTestLogger();
        this.engine = new ScriptingEngine(this.logger);
        this.engine.debug = true;
        this.testModule = this.engine.createNativeModule("test_module", "org.openzen.zenscript.scripting_tests", new JavaNativeModule[0]);
        SharedGlobals.currentlyActiveLogger = this.logger;
        this.getRequiredClasses().stream().distinct().forEach(requiredClass -> {
            this.testModule.addGlobals((Class<?>)requiredClass);
            this.testModule.addClass((Class<?>)requiredClass);
        });
        this.engine.registerNativeProvided(this.testModule);
    }

    public void executeEngine() {
        this.executeEngine(false);
    }

    public void executeEngine(boolean allowError) {
        try {
            FunctionParameterList parameters = this.getParameters();
            SemanticModule script_tests = this.engine.createScriptedModule("script_tests", this.sourceFiles.toArray(new SourceFile[0]), this.getBEP(), parameters.getParameters(), new String[0]);
            boolean scriptsValid = script_tests.isValid();
            if (allowError) {
                if (!scriptsValid) {
                    this.logger.setEngineComplete();
                    return;
                }
            } else {
                Assertions.assertTrue((boolean)scriptsValid, (String)"Scripts are not valid!");
            }
            this.engine.registerCompiled(script_tests);
            this.engine.run(parameters.getParameterMap());
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assertions.fail((String)"Error in Engine execution", (Throwable)e);
        }
        this.logger.setEngineComplete();
    }

    public void addScript(String content) {
        this.addScript(content, "test_script_" + this.sourceFiles.size() + ".zs");
    }

    public void addScript(String content, String name) {
        this.sourceFiles.add(new LiteralSourceFile(name, content));
    }

    public BracketExpressionParser getBEP() {
        return null;
    }

    public FunctionParameterList getParameters() {
        FunctionParameterList functionParameterList = new FunctionParameterList();
        ArrayTypeID stringArrayType = this.engine.registry.getArray(BasicTypeID.STRING, 1);
        FunctionParameter args = new FunctionParameter(stringArrayType, "args");
        functionParameterList.addParameter(args, new String[]{"a", "b", "c"});
        return functionParameterList;
    }

    public List<Class<?>> getRequiredClasses() {
        ArrayList result = new ArrayList();
        result.add(SharedGlobals.class);
        return result;
    }
}

