/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.scriptingexample.tests.helpers;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.openzen.zenscript.scriptingexample.tests.helpers.ZenCodeTest;

public class ScriptBuilder {
    private final Map<String, String> scriptNameToScript = new LinkedHashMap<String, String>();
    private StringJoiner currentScriptJoiner;
    private String currentScriptName;

    private ScriptBuilder() {
        this.startNewScript();
    }

    public static ScriptBuilder create() {
        return new ScriptBuilder();
    }

    public ScriptBuilder add(String line) {
        this.currentScriptJoiner.add(line);
        return this;
    }

    public ScriptBuilder startNewScript() {
        return this.startNewScript(null);
    }

    public ScriptBuilder startNewScript(String fileName) {
        if (this.currentScriptJoiner != null && this.currentScriptJoiner.length() != 0) {
            this.scriptNameToScript.put(this.currentScriptName, this.currentScriptJoiner.toString());
        }
        this.currentScriptJoiner = new StringJoiner(System.lineSeparator());
        this.currentScriptName = fileName == null ? "test_script_" + (this.scriptNameToScript.size() + 1) + ".zs" : fileName;
        return this;
    }

    public void appendScriptsToTest(ZenCodeTest test) {
        this.startNewScript();
        this.scriptNameToScript.forEach((name, content) -> test.addScript((String)content, (String)name));
    }

    public void execute(ZenCodeTest test, LogTolerance logTolerance) {
        this.appendScriptsToTest(test);
        test.executeEngine(logTolerance != LogTolerance.NO_ERRORS);
        switch (logTolerance) {
            case NO_WARNINGS: {
                test.logger.assertNoWarnings();
            }
            case NO_ERRORS: {
                test.logger.assertNoErrors();
            }
        }
    }

    public void execute(ZenCodeTest test) {
        this.execute(test, LogTolerance.NO_WARNINGS);
    }

    public static enum LogTolerance {
        NO_WARNINGS,
        NO_ERRORS,
        ALLOW_ERRORS;

    }
}

