/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.scriptingexample.tests.actual_test.variants;

import org.junit.jupiter.api.Test;
import org.openzen.zenscript.scriptingexample.tests.helpers.ScriptBuilder;
import org.openzen.zenscript.scriptingexample.tests.helpers.ZenCodeTest;

public class VariantTestOptional
extends ZenCodeTest {
    private static ScriptBuilder createBuilder() {
        return ScriptBuilder.create().add("public variant Optional<T> {").add("    Present(T),").add("    Empty;").add("").add("    public expect() as T {").add("        return match this {").add("            Present(value) => value,").add("            Empty() => panic('Expect called on empty value')").add("        };").add("    }").add("").add("    public ifPresent(consumer as function(value as T) as void) as void {").add("        if(isPresent) {").add("            consumer(expect());").add("        }").add("    }").add("").add("    public get isPresent as bool => match(this) {").add("        Present(value) => true,").add("        Empty => false").add("    };").add("}");
    }

    @Test
    public void testIsPresent() {
        VariantTestOptional.createBuilder().add("var opt as Optional<string> = Present('Hello World');").add("println(opt.isPresent);").add("opt = Empty;").add("println(opt.isPresent);").execute(this);
        this.logger.assertPrintOutput(0, "true");
        this.logger.assertPrintOutput(1, "false");
    }

    @Test
    public void testExpectPresent() {
        VariantTestOptional.createBuilder().add("var opt as Optional<string> = Present('Hello World');").add("println(opt.expect());").execute(this);
        this.logger.assertPrintOutputSize(1);
        this.logger.assertPrintOutput(0, "Hello World");
    }

    @Test
    public void testExpectEmpty() {
        VariantTestOptional.createBuilder().add("var opt as Optional<string> = Empty;").add("println(opt.expect());").execute(this, ScriptBuilder.LogTolerance.ALLOW_ERRORS);
        this.logger.errors().assertSize(1);
        this.logger.errors().assertLine(0, "Expect called on empty value");
    }

    @Test
    public void testIfPresentPresent() {
        VariantTestOptional.createBuilder().add("var opt as Optional<string> = Present('Hello World');").add("opt.ifPresent((value) => println(value));").execute(this);
        this.logger.assertPrintOutputSize(1);
        this.logger.assertPrintOutput(0, "Hello World");
    }

    @Test
    public void testIfPresentEmpty() {
        VariantTestOptional.createBuilder().add("var opt as Optional<string> = Empty;").add("opt.ifPresent((value) => println(value));").execute(this);
        this.logger.assertPrintOutputSize(0);
    }
}

