/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.scriptingexample.tests.actual_test.java_native.operators;

import java.util.List;
import org.junit.jupiter.api.Test;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zenscript.scriptingexample.tests.helpers.ScriptBuilder;
import org.openzen.zenscript.scriptingexample.tests.helpers.ZenCodeTest;
import org.openzen.zenscript.scriptingexample.tests.helpers.ZenCodeTestLogger;

public class OperatorEquals
extends ZenCodeTest {
    @Override
    public List<Class<?>> getRequiredClasses() {
        List<Class<?>> requiredClasses = super.getRequiredClasses();
        requiredClasses.add(ClassWithEqualsOperator.class);
        requiredClasses.add(ClassWithEqualsAndNotEqualsOperator.class);
        return requiredClasses;
    }

    @Test
    public void canUseEqualsOperator() {
        ScriptBuilder.create().add("var a = createWithEquals('A');").add("var b = createWithEquals('B');").add("var a2 = createWithEquals('A');").add("println(a == b);").add("println(a == a2);").execute(this);
        this.logger.assertPrintOutputSize(2);
        this.logger.assertPrintOutput(0, "false");
        this.logger.assertPrintOutput(1, "true");
    }

    @Test
    public void canUseImplicitNotEqualsOperator() {
        ScriptBuilder.create().add("var a = createWithEquals('A');").add("var b = createWithEquals('B');").add("var a2 = createWithEquals('A');").add("println(a != b);").add("println(a != a2);").execute(this);
        this.logger.assertPrintOutputSize(2);
        this.logger.assertPrintOutput(0, "true");
        this.logger.assertPrintOutput(1, "false");
    }

    @Test
    public void useExplicitNotEqualsWhenPresent() {
        ClassWithEqualsAndNotEqualsOperator.logger = this.logger;
        ScriptBuilder.create().add("var a = createWithEqualsAndNotEquals('A');").add("var b = createWithEqualsAndNotEquals('B');").add("var a2 = createWithEqualsAndNotEquals('A');").add("println(a != b);").add("println(a != a2);").add("println(a == b);").add("println(a == a2);").execute(this);
        this.logger.assertPrintOutputSize(8);
        this.logger.assertPrintOutput(0, "notEqualsCalled");
        this.logger.assertPrintOutput(1, "true");
        this.logger.assertPrintOutput(2, "notEqualsCalled");
        this.logger.assertPrintOutput(3, "false");
        this.logger.assertPrintOutput(4, "equalsCalled");
        this.logger.assertPrintOutput(5, "false");
        this.logger.assertPrintOutput(6, "equalsCalled");
        this.logger.assertPrintOutput(7, "true");
    }

    @ZenCodeType.Name(value="test_module.java_native.operator.equals.ClassWithEqualsAndNotEqualsOperator")
    public static final class ClassWithEqualsAndNotEqualsOperator {
        private static ZenCodeTestLogger logger;
        private final String value;

        public ClassWithEqualsAndNotEqualsOperator(String value) {
            this.value = value;
        }

        @ZenCodeGlobals.Global
        public static ClassWithEqualsAndNotEqualsOperator createWithEqualsAndNotEquals(String value) {
            return new ClassWithEqualsAndNotEqualsOperator(value);
        }

        @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
        public boolean equalsOperator(ClassWithEqualsAndNotEqualsOperator other) {
            logger.logPrintln("equalsCalled");
            return this.value.equals(other.value);
        }

        @ZenCodeType.Operator(value=ZenCodeType.OperatorType.NOTEQUALS)
        public boolean notEqualsOperator(ClassWithEqualsAndNotEqualsOperator other) {
            logger.logPrintln("notEqualsCalled");
            return !this.value.equals(other.value);
        }
    }

    @ZenCodeType.Name(value="test_module.java_native.operator.equals.ClassWithEqualsOperator")
    public static final class ClassWithEqualsOperator {
        private final String value;

        public ClassWithEqualsOperator(String value) {
            this.value = value;
        }

        @ZenCodeGlobals.Global
        public static ClassWithEqualsOperator createWithEquals(String value) {
            return new ClassWithEqualsOperator(value);
        }

        @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
        public boolean equalsOperator(ClassWithEqualsOperator other) {
            return this.value.equals(other.value);
        }
    }
}

