/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.scriptingexample.tests.actual_test.java_native.operators;

import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zenscript.codemodel.CompareType;
import org.openzen.zenscript.scriptingexample.tests.helpers.ScriptBuilder;
import org.openzen.zenscript.scriptingexample.tests.helpers.ZenCodeTest;
import org.openzen.zenscript.scriptingexample.tests.helpers.ZenCodeTestLogger;

public class OperatorCompare
extends ZenCodeTest {
    public static Stream<Arguments> getTestCases() {
        Stream.Builder<Arguments> builder = Stream.builder();
        int[] leftOperands = new int[]{1, 2, 3};
        int[] rightOperands = new int[]{2};
        for (int leftOperand : leftOperands) {
            for (int rightOperand : rightOperands) {
                builder.add(Arguments.of((Object[])new Object[]{CompareType.EQ.str, leftOperand, rightOperand, leftOperand == rightOperand}));
                builder.add(Arguments.of((Object[])new Object[]{CompareType.NE.str, leftOperand, rightOperand, leftOperand != rightOperand}));
                builder.add(Arguments.of((Object[])new Object[]{CompareType.GT.str, leftOperand, rightOperand, leftOperand > rightOperand}));
                builder.add(Arguments.of((Object[])new Object[]{CompareType.GE.str, leftOperand, rightOperand, leftOperand >= rightOperand}));
                builder.add(Arguments.of((Object[])new Object[]{CompareType.LT.str, leftOperand, rightOperand, leftOperand < rightOperand}));
                builder.add(Arguments.of((Object[])new Object[]{CompareType.LE.str, leftOperand, rightOperand, leftOperand <= rightOperand}));
            }
        }
        return builder.build();
    }

    @Override
    public List<Class<?>> getRequiredClasses() {
        List<Class<?>> requiredClasses = super.getRequiredClasses();
        requiredClasses.add(ClassWithOperatorCompare.class);
        requiredClasses.add(ClassWithCompareAndEquals.class);
        return requiredClasses;
    }

    @BeforeEach
    public void before() {
        ClassWithCompareAndEquals.logger = this.logger;
    }

    @ParameterizedTest(name="{1} {0} {2} == {3}")
    @MethodSource(value={"getTestCases"})
    @Disabled(value="Test is invalid due to Object == already being an operator.")
    public void testOperatorWorks(String type, int a, int b, boolean compareResult) {
        ScriptBuilder.create().add("var a = createWithCompare(" + a + ");").add("var b = createWithCompare(" + b + ");").add("println(a " + type + "b);").execute(this);
        this.logger.assertPrintOutputSize(1);
        this.logger.assertPrintOutput(0, Boolean.toString(compareResult));
    }

    @Test
    public void testEqualsOperatorUsedWhenPresentInsteadOfCompare() {
        ScriptBuilder.create().add("var a = createWithCompareAndEquals(1);").add("var b = createWithCompareAndEquals(2);").add("println(a == b);").add("println(a != b);").add("println(a > b);").add("println(a >= b);").add("println(a < b);").add("println(a <= b);").execute(this);
        this.logger.assertPrintOutputSize(12);
        this.logger.assertPrintOutput(0, "equals");
        this.logger.assertPrintOutput(1, "false");
        this.logger.assertPrintOutput(2, "equals");
        this.logger.assertPrintOutput(3, "true");
        this.logger.assertPrintOutput(4, "compare");
        this.logger.assertPrintOutput(5, "false");
        this.logger.assertPrintOutput(6, "compare");
        this.logger.assertPrintOutput(7, "false");
        this.logger.assertPrintOutput(8, "compare");
        this.logger.assertPrintOutput(9, "true");
        this.logger.assertPrintOutput(10, "compare");
        this.logger.assertPrintOutput(11, "true");
    }

    @ZenCodeType.Name(value="test_module.java_native.operator.compare.ClassWithCompareAndEquals")
    public static final class ClassWithCompareAndEquals {
        private static ZenCodeTestLogger logger;
        private final int i;

        public ClassWithCompareAndEquals(int i) {
            this.i = i;
        }

        @ZenCodeGlobals.Global
        public static ClassWithCompareAndEquals createWithCompareAndEquals(int i) {
            return new ClassWithCompareAndEquals(i);
        }

        @ZenCodeType.Operator(value=ZenCodeType.OperatorType.COMPARE)
        public int compare(ClassWithCompareAndEquals other) {
            logger.logPrintln("compare");
            return Integer.compare(this.i, other.i);
        }

        @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
        public boolean equals(ClassWithCompareAndEquals other) {
            logger.logPrintln("equals");
            return this.i == other.i;
        }
    }

    @ZenCodeType.Name(value="test_module.java_native.operator.compare.ClassWithOperatorCompare")
    public static final class ClassWithOperatorCompare {
        private final int i;

        public ClassWithOperatorCompare(int i) {
            this.i = i;
        }

        @ZenCodeGlobals.Global
        public static ClassWithOperatorCompare createWithCompare(int i) {
            return new ClassWithOperatorCompare(i);
        }

        @ZenCodeType.Operator(value=ZenCodeType.OperatorType.COMPARE)
        public int compare(ClassWithOperatorCompare other) {
            return Integer.compare(this.i, other.i);
        }
    }
}

