/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.scriptingexample.tests.actual_test.java_native.enums;

import java.util.List;
import org.junit.jupiter.api.Test;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zenscript.scriptingexample.tests.helpers.ScriptBuilder;
import org.openzen.zenscript.scriptingexample.tests.helpers.ZenCodeTest;

public class EnumMemberTests
extends ZenCodeTest {
    @Override
    public List<Class<?>> getRequiredClasses() {
        List<Class<?>> requiredClasses = super.getRequiredClasses();
        requiredClasses.add(MyEnum.class);
        requiredClasses.add(GlobalEnumUser.class);
        return requiredClasses;
    }

    @Test
    public void EnumMembersMustBeRetrievableByTypeHintAndName() {
        ScriptBuilder.create().add("println(getName(A));").execute(this);
        this.logger.assertPrintOutputSize(1);
        this.logger.assertPrintOutput(0, "A");
    }

    @ZenCodeType.Name(value="test_module.GlobalEnumUser")
    public static final class GlobalEnumUser {
        @ZenCodeGlobals.Global
        public static String getName(MyEnum myEnum) {
            return myEnum.name();
        }
    }

    @ZenCodeType.Name(value="test_module.MyEnum")
    public static enum MyEnum {
        A,
        B,
        C;

    }
}

