/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.scriptingexample.tests.actual_test.java_native;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.junit.jupiter.api.Test;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zenscript.scriptingexample.tests.SharedGlobals;
import org.openzen.zenscript.scriptingexample.tests.helpers.ZenCodeTest;

public class FunctionalInterfaceTests
extends ZenCodeTest {
    @Override
    public List<Class<?>> getRequiredClasses() {
        List<Class<?>> requiredClasses = super.getRequiredClasses();
        requiredClasses.add(TestClass.class);
        requiredClasses.add(StringModifier.class);
        requiredClasses.add(SharedGlobals.class);
        return requiredClasses;
    }

    @Test
    public void testFunctionalInterface() {
        this.addScript("var modified = modifyString('test', (strings, context) => { return strings; });\nfor str in modified { println(str); }", "FunctionalInterfaceTests_testFunctionalInterface.zs");
        this.executeEngine();
        this.logger.assertNoErrors();
        this.logger.assertNoWarnings();
        this.logger.assertPrintOutputSize(1);
        this.logger.assertPrintOutput(0, "test");
    }

    @Test
    public void testBiFunction() {
        this.addScript("var modified = stringFunction('test', (strings, context) => {return strings;});\nfor str in modified { println(str); }", "FunctionalInterfaceTests_testBiFunction.zs");
        this.executeEngine();
        this.logger.assertNoErrors();
        this.logger.assertNoWarnings();
        this.logger.assertPrintOutputSize(1);
        this.logger.assertPrintOutput(0, "test");
    }

    @FunctionalInterface
    @ZenCodeType.Name(value="test_module.java_native.StringModifier")
    public static interface StringModifier {
        public List<String> modify(List<String> var1, boolean var2);
    }

    @ZenCodeType.Name(value="test_module.java_native.TestClass")
    public static final class TestClass {
        @ZenCodeGlobals.Global
        public static List<String> modifyString(String baseString, StringModifier modifier) {
            return modifier.modify(Collections.singletonList(baseString), false);
        }

        @ZenCodeGlobals.Global
        public static List<String> stringFunction(String baseString, BiFunction<List<String>, Boolean, List<String>> function) {
            return function.apply(Collections.singletonList(baseString), false);
        }
    }
}

