/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.scriptingexample.tests.actual_test.java_native;

import org.junit.jupiter.api.Test;
import org.openzen.zenscript.scriptingexample.tests.helpers.ZenCodeTest;

public class AutoBoxingTest
extends ZenCodeTest {
    @Test
    public void testIndexSetCorrectlyBoxesKeysAndValues() {
        this.addScript("var item_values = {} as int[string];\nitem_values[\"box\"] = 1;\nitem_values[\"test\"] = 9;\nprintln(item_values[\"box\"]);\n\nvar value_items = {} as string[int];\nvalue_items[1] = \"box\";\nvalue_items[9] = \"test\";\nprintln(value_items[9]);");
        this.executeEngine();
        this.logger.assertNoErrors();
        this.logger.assertNoWarnings();
        this.logger.assertPrintOutputSize(2);
        this.logger.assertPrintOutput(0, Integer.toString(1));
        this.logger.assertPrintOutput(1, "test");
    }

    @Test
    public void testGenericParameterBoxing() {
        this.addScript("public class Duad<A, B> {\n    public var a as A : get;\n    public var b as B : get;\n    public this(a as A, b as B) {\n        this.a = a;\n        this.b = b;\n    }\n}\n\npublic function duadExample(name as string, age as int) as Duad<string, int> {\n    return new Duad<string, int>(name, age);\n}\n\nvar jimmy = duadExample(\"Jimmy\", 19);\n\nprintln(jimmy.a);println(jimmy.b);");
        this.executeEngine();
        this.logger.assertNoErrors();
        this.logger.assertNoWarnings();
        this.logger.assertPrintOutputSize(2);
        this.logger.assertPrintOutput(0, "Jimmy");
        this.logger.assertPrintOutput(1, "19");
    }
}

