/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.scriptingexample.tests.actual_test.functions;

import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zenscript.scriptingexample.tests.SharedGlobals;
import org.openzen.zenscript.scriptingexample.tests.helpers.ScriptBuilder;
import org.openzen.zenscript.scriptingexample.tests.helpers.ZenCodeTest;

public class Overloads
extends ZenCodeTest {
    @Override
    public List<Class<?>> getRequiredClasses() {
        List<Class<?>> requiredClasses = super.getRequiredClasses();
        requiredClasses.add(GlobalEnumUser.class);
        return requiredClasses;
    }

    @Test
    public void testArrayOverloads() {
        ScriptBuilder.create().add("printArray([1, 2, 3]);").add("printArray(['one', 'two', 'three']);").execute(this);
        this.logger.assertPrintOutputSize(2);
        this.logger.assertPrintOutput(0, "Numbers: [1, 2, 3]");
        this.logger.assertPrintOutput(1, "Strings: [one, two, three]");
    }

    @ZenCodeType.Name(value="test_module.GlobalPrinter")
    public static final class GlobalEnumUser {
        @ZenCodeGlobals.Global
        public static void printArray(int[] numbers) {
            SharedGlobals.println("Numbers: " + Arrays.toString(numbers));
        }

        @ZenCodeGlobals.Global
        public static void printArray(String[] strings) {
            SharedGlobals.println("Strings: " + Arrays.toString(strings));
        }
    }
}

