/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.scriptingexample.tests.actual_test.file_names;

import java.io.File;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.openzen.zenscript.scriptingexample.tests.helpers.ScriptBuilder;
import org.openzen.zenscript.scriptingexample.tests.helpers.ZenCodeTest;

public class FileNamesAndSpecialCharacters
extends ZenCodeTest {
    public static char[] specialCharsToTest() {
        return new char[]{'.', '1', '%', '$', '_', '!', '/', '\\', '\u0000', '\u0001', ' ', ';', ':', '-', '|', '[', ']'};
    }

    @BeforeEach
    public void disableDebug() {
        this.engine.debug = false;
    }

    @ParameterizedTest(name="[{index}] Checking special Character '{0}'")
    @MethodSource(value={"specialCharsToTest"})
    public void TestThatFilenameCanContainCharacter(char characterToTest) {
        ScriptBuilder.create().startNewScript(String.format("t%1$se%1$ss%1$st.zs", Character.valueOf(characterToTest))).add("println('Hello World');").execute(this);
        this.logger.assertNoWarnings();
        this.logger.assertNoErrors();
        this.logger.assertPrintOutputSize(1);
        this.logger.assertPrintOutput(0, "Hello World");
    }

    @ParameterizedTest
    @MethodSource(value={"specialCharsToTest"})
    public void TestThatFilesWithSpecialCharacterFileNameAreAccessibleInsideOtherScripts(char characterToTest) {
        ScriptBuilder.create().startNewScript(String.format("t%1$se%1$ss%1$st_1.zs", Character.valueOf(characterToTest))).add("public function getTheString() as string => 'Hello World';").startNewScript(String.format("t%1$se%1$ss%1$st_2.zs", Character.valueOf(characterToTest))).add("println(getTheString());").execute(this);
        this.logger.assertNoWarnings();
        this.logger.assertNoErrors();
        this.logger.assertPrintOutputSize(1);
        this.logger.assertPrintOutput(0, "Hello World");
    }

    @ParameterizedTest
    @MethodSource(value={"specialCharsToTest"})
    public void TestThatFilesWithSpecialCharactersCanBePutInSubFolders(char characterToTest) {
        ScriptBuilder.create().startNewScript(String.format("some%2$sfolder%2$st%1$se%1$ss%1$st_1.zs", Character.valueOf(characterToTest), Character.valueOf(File.separatorChar))).add("public function getTheString() as string => 'Hello World';").startNewScript(String.format("some%2$sfolder%2$st%1$se%1$ss%1$st_2.zs", Character.valueOf(characterToTest), Character.valueOf(File.separatorChar))).add("println(getTheString());").execute(this);
        this.logger.assertNoWarnings();
        this.logger.assertNoErrors();
        this.logger.assertPrintOutputSize(1);
        this.logger.assertPrintOutput(0, "Hello World");
    }
}

