/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.scriptingexample.tests.actual_test.arrays;

import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.openzen.zenscript.scriptingexample.tests.helpers.ScriptBuilder;
import org.openzen.zenscript.scriptingexample.tests.helpers.ZenCodeTest;

public class ArrayCopy
extends ZenCodeTest {
    @ParameterizedTest
    @ValueSource(strings={"int", "int?", "string", "string?"})
    public void canCloneArray(String baseType) {
        ScriptBuilder.create().add("var oldArray = [0, 1, 2, 3, 4] as " + baseType + "[];").add("var newArray = oldArray.copy();").add("newArray[0] = 99;").add("println(newArray[0]);").add("println(oldArray[0]);").execute(this);
        this.logger.assertPrintOutputSize(2);
        this.logger.assertPrintOutput(0, "99");
        this.logger.assertPrintOutput(1, "0");
    }

    @ParameterizedTest
    @ValueSource(strings={"int", "int?", "string", "string?"})
    public void canCopyResize(String baseType) {
        int newSize = 3;
        ScriptBuilder.create().add("var oldArray = [0, 1, 2, 3, 4] as " + baseType + "[];").add("var newArray = oldArray.copy(3);").add("newArray[0] = 99;").add("println(newArray[0]);").add("println(oldArray[0]);").add("println(newArray.length);").add("println(oldArray.length);").execute(this);
        this.logger.assertPrintOutputSize(4);
        this.logger.assertPrintOutput(0, "99");
        this.logger.assertPrintOutput(1, "0");
        this.logger.assertPrintOutput(2, "3");
        this.logger.assertPrintOutput(3, "5");
    }
}

