/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.services;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.IIngredientConditionSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.mixin.common.access.registry.AccessRegistrySynchronization;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public interface IRegistryHelper {
    default public Set<ResourceKey<?>> serverOnlyRegistries() {
        return AccessRegistrySynchronization.crafttweaker$callOwnedNetworkableRegistries(CraftTweakerAPI.getAccessibleElementsProvider().registryAccess()).map(RegistryAccess.RegistryEntry::f_206233_).collect(Collectors.toSet());
    }

    default public void registerSerializer(MappedRegistry<IIngredientTransformerSerializer<?>> registry, IIngredientTransformerSerializer<?> serializer) {
        registry.m_255290_(ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)serializer.getType()), serializer, Lifecycle.stable());
    }

    default public void registerSerializer(MappedRegistry<IIngredientConditionSerializer<?>> registry, IIngredientConditionSerializer<?> serializer) {
        registry.m_255290_(ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)serializer.getType()), serializer, Lifecycle.stable());
    }

    public void init();

    default public Optional<ResourceLocation> maybeGetRegistryKey(Object object) {
        if (object instanceof Item) {
            Item obj = (Item)object;
            return this.nonDefaultKey((Registry)BuiltInRegistries.f_257033_, (Object)obj);
        }
        if (object instanceof Potion) {
            Potion obj = (Potion)object;
            return this.nonDefaultKey((Registry)BuiltInRegistries.f_256980_, (Object)obj);
        }
        if (object instanceof EntityType) {
            EntityType obj = (EntityType)object;
            return this.nonDefaultKey((Registry)BuiltInRegistries.f_256780_, (Object)obj);
        }
        if (object instanceof RecipeType) {
            RecipeType obj = (RecipeType)object;
            return this.nonDefaultKey(BuiltInRegistries.f_256990_, obj);
        }
        if (object instanceof RecipeSerializer) {
            RecipeSerializer obj = (RecipeSerializer)object;
            return this.nonDefaultKey(BuiltInRegistries.f_256769_, obj);
        }
        if (object instanceof Attribute) {
            Attribute obj = (Attribute)object;
            return this.nonDefaultKey(BuiltInRegistries.f_256951_, obj);
        }
        if (object instanceof Fluid) {
            Fluid obj = (Fluid)object;
            return this.nonDefaultKey((Registry)BuiltInRegistries.f_257020_, (Object)obj);
        }
        if (object instanceof Enchantment) {
            Enchantment obj = (Enchantment)object;
            return this.nonDefaultKey(BuiltInRegistries.f_256876_, obj);
        }
        if (object instanceof Block) {
            Block obj = (Block)object;
            return this.nonDefaultKey((Registry)BuiltInRegistries.f_256975_, (Object)obj);
        }
        if (object instanceof MobEffect) {
            MobEffect obj = (MobEffect)object;
            return this.nonDefaultKey(BuiltInRegistries.f_256974_, obj);
        }
        if (object instanceof VillagerProfession) {
            VillagerProfession obj = (VillagerProfession)object;
            return this.nonDefaultKey((Registry)BuiltInRegistries.f_256735_, (Object)obj);
        }
        if (object instanceof Biome) {
            Biome obj = (Biome)object;
            return this.nonDefaultKey(CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().m_175515_(Registries.f_256952_), obj);
        }
        if (object instanceof SoundEvent) {
            SoundEvent obj = (SoundEvent)object;
            return this.nonDefaultKey(BuiltInRegistries.f_256894_, obj);
        }
        return Optional.empty();
    }

    private <T> Optional<ResourceLocation> nonDefaultKey(Registry<T> registry, T obj) {
        DefaultedRegistry def;
        ResourceLocation key = registry.m_7981_(obj);
        if (registry instanceof DefaultedRegistry && (def = (DefaultedRegistry)registry).m_122315_().equals((Object)key) && !def.m_7745_(key).equals(obj)) {
            return Optional.empty();
        }
        return Optional.ofNullable(key);
    }

    default public Registry<Biome> biomes() {
        return CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().m_175515_(Registries.f_256952_);
    }

    default public <T> Holder<T> makeHolder(ResourceKey<?> resourceKey, Either<T, ResourceLocation> objectOrKey) {
        return (Holder)objectOrKey.map(t -> this.makeHolder(resourceKey, t), key -> this.makeHolder(resourceKey, (ResourceLocation)key));
    }

    default public <T> Holder<T> makeHolder(ResourceKey<?> resourceKey, T object) {
        Registry registry = CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().m_175515_((ResourceKey)GenericUtil.uncheck(resourceKey));
        return (Holder)registry.m_7854_(object).flatMap(arg_0 -> ((Registry)registry).m_203636_(arg_0)).orElseThrow(() -> new RuntimeException("Unable to make holder for registry: " + registry + " and object: " + object));
    }

    default public <T> Holder<T> makeHolder(ResourceKey<?> resourceKey, ResourceLocation key) {
        Registry registry = CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().m_175515_((ResourceKey)GenericUtil.uncheck(resourceKey));
        if (!registry.m_7804_(key)) {
            throw new IllegalArgumentException("Registry does not contain key: '" + key + "'");
        }
        return (Holder)registry.m_203636_(ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)key)).orElseThrow(() -> new RuntimeException("Unable to make holder for registry: " + registry + " and id: " + key));
    }
}

