/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.services;

import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientConditioned;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientTransformed;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.loot.modifier.ILootModifier;
import com.blamejared.crafttweaker.api.mod.Mod;
import com.blamejared.crafttweaker.api.mod.PlatformMod;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.villager.CTTradeObject;
import com.blamejared.crafttweaker.api.villager.trade.type.IBasicItemListing;
import com.blamejared.crafttweaker.mixin.common.access.item.AccessIngredient;
import com.blamejared.crafttweaker.platform.helper.inventory.IInventoryWrapper;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public interface IPlatformHelper {
    default public String getLogFormat() {
        return "[%d{HH:mm:ss.SSS}][%level][%markerSimpleName]: %msg%n%throwable";
    }

    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    public boolean isDataGen();

    public List<Mod> getMods();

    public Optional<Mod> getMod(String var1);

    public IItemStack createItemStack(ItemStack var1);

    public IItemStack createItemStackMutable(ItemStack var1);

    public IFluidStack createFluidStack(Fluid var1, long var2, @Nullable CompoundTag var4);

    public IFluidStack createFluidStackMutable(Fluid var1, long var2, @Nullable CompoundTag var4);

    public <T> IFluidStack createFluidStack(T var1);

    public <T> IFluidStack createFluidStackMutable(T var1);

    public Fluid getBucketContent(BucketItem var1);

    public Path getGameDirectory();

    public <T extends Annotation> Stream<? extends Class<?>> findClassesWithAnnotation(Class<T> var1, Consumer<PlatformMod> var2, Predicate<Either<T, Map<String, Object>>> var3);

    public String findMappedMethodName(Class<?> var1, String var2, Class<?> var3, Class<?> ... var4);

    public String findMappedFieldName(Class<?> var1, String var2, Class<?> var3);

    default public void registerCustomTradeConverters(Map<Class<? extends VillagerTrades.ItemListing>, Function<VillagerTrades.ItemListing, CTTradeObject>> classFunctionMap) {
    }

    public Map<ResourceLocation, ILootModifier> getLootModifiersMap();

    public IInventoryWrapper getPlayerInventory(Player var1);

    default public boolean canItemStacksStack(ItemStack first, ItemStack second) {
        if (first.m_41619_() || !ItemStack.m_41656_((ItemStack)first, (ItemStack)second) || first.m_41782_() != second.m_41782_()) {
            return false;
        }
        return !first.m_41782_() || first.m_41783_().equals((Object)second.m_41783_());
    }

    public boolean doCraftingTableRecipesConflict(IRecipeManager<?> var1, Recipe<?> var2, Recipe<?> var3);

    public Set<MutableComponent> getFluidsForDump(ItemStack var1, Player var2, InteractionHand var3);

    public CompoundTag getCustomData(Entity var1);

    public CompoundTag getPersistentData(ServerPlayer var1);

    default public void addFoodPropertiesEffect(FoodProperties internal, MobEffectInstance effect, float probability) {
        internal.m_38749_().add(Pair.of((Object)effect, (Object)Float.valueOf(probability)));
    }

    default public void removeFoodPropertiesEffect(FoodProperties internal, MobEffectInstance effect) {
        internal.m_38749_().removeIf(pair -> ((MobEffectInstance)pair.getFirst()).equals((Object)effect));
    }

    default public void removeFoodPropertiesEffect(FoodProperties internal, MobEffect effect) {
        internal.m_38749_().removeIf(pair -> ((MobEffectInstance)pair.getFirst()).m_19544_() == effect);
    }

    public boolean doesIngredientRequireTesting(Ingredient var1);

    default public void invalidateIngredients(List<Ingredient> ingredients) {
        ingredients.forEach(ingredient -> ((AccessIngredient)ingredient).crafttweaker$setItemStacks(null));
        ingredients.clear();
    }

    public Ingredient getIngredientAny();

    public Ingredient getIngredientList(List<Ingredient> var1);

    public <T extends IIngredient> Ingredient getIngredientConditioned(IIngredientConditioned<T> var1);

    public <T extends IIngredient> Ingredient getIngredientTransformed(IIngredientTransformed<T> var1);

    public Ingredient getIngredientPartialTag(ItemStack var1);

    public Stream<GameProfile> fakePlayers();

    public boolean isFakePlayer(Player var1);

    default public ItemStack getBasicTradePrice(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get price for '%s'".formatted(internal));
    }

    default public ItemStack getBasicTradePrice2(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get price2 for '%s'".formatted(internal));
    }

    default public ItemStack getBasicTradeForSale(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get forSale for '%s'".formatted(internal));
    }

    default public int getBasicTradeMaxTrades(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get maxTrades for '%s'".formatted(internal));
    }

    default public int getBasicTradeXp(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get xp for '%s'".formatted(internal));
    }

    default public float getBasicTradePriceMult(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get priceMult for '%s'".formatted(internal));
    }
}

