/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.loot.modifier;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.loot.LootManager;
import com.blamejared.crafttweaker.api.loot.condition.LootConditions;
import com.blamejared.crafttweaker.api.loot.modifier.ILootModifier;
import com.blamejared.crafttweaker.natives.loot.condition.ExpandLootItemEntityPropertyCondition;
import com.blamejared.crafttweaker.natives.loot.condition.ExpandLootItemKilledByPlayerCondition;
import com.blamejared.crafttweaker.natives.predicate.ExpandEntityEquipmentPredicate;
import com.blamejared.crafttweaker.natives.predicate.ExpandEntityPredicate;
import com.blamejared.crafttweaker.natives.predicate.ExpandItemPredicate;
import com.blamejared.crafttweaker.natives.predicate.ExpandMinMaxBoundsInts;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="vanilla/api/loot/modifier/EntityLootModifiers")
@ZenCodeType.Expansion(value="crafttweaker.api.entity.EntityType<crafttweaker.api.entity.Entity>")
@ZenRegister
public class ModifierSpecificExpandEntityType {
    @ZenCodeType.Method
    public static void addLootModifier(EntityType<Entity> internal, String name, ILootModifier modifier) {
        LootManager.INSTANCE.getModifierManager().register(name, LootConditions.only(ModifierSpecificExpandEntityType.makeForType(internal)), modifier);
    }

    @ZenCodeType.Method
    public static void addPlayerOnlyLootModifier(EntityType<Entity> internal, String name, ILootModifier modifier) {
        LootManager.INSTANCE.getModifierManager().register(name, LootConditions.allOf(ModifierSpecificExpandEntityType.makeForType(internal), ExpandLootItemKilledByPlayerCondition.create()), modifier);
    }

    @ZenCodeType.Method
    public static void addWeaponOnlyLootModifier(EntityType<Entity> internal, String name, IItemStack weapon, ILootModifier modifier) {
        ModifierSpecificExpandEntityType.addWeaponOnlyLootModifier(internal, name, weapon, false, modifier);
    }

    @ZenCodeType.Method
    public static void addWeaponOnlyLootModifier(EntityType<Entity> internal, String name, IItemStack weapon, boolean matchDamage, ILootModifier modifier) {
        ModifierSpecificExpandEntityType.addWeaponOnlyLootModifier(internal, name, weapon, matchDamage, false, modifier);
    }

    @ZenCodeType.Method
    public static void addWeaponOnlyLootModifier(EntityType<Entity> internal, String name, IItemStack weapon, boolean matchDamage, boolean matchNbt, ILootModifier modifier) {
        LootManager.INSTANCE.getModifierManager().register(name, LootConditions.allOf(ModifierSpecificExpandEntityType.makeForType(internal), ModifierSpecificExpandEntityType.makeForWeapon(weapon, matchDamage, matchNbt)), modifier);
    }

    @ZenCodeType.Method
    public static void addWeaponAndPlayerOnlyLootModifier(EntityType<Entity> internal, String name, IItemStack weapon, ILootModifier modifier) {
        ModifierSpecificExpandEntityType.addWeaponAndPlayerOnlyLootModifier(internal, name, weapon, false, modifier);
    }

    @ZenCodeType.Method
    public static void addWeaponAndPlayerOnlyLootModifier(EntityType<Entity> internal, String name, IItemStack weapon, boolean matchDamage, ILootModifier modifier) {
        ModifierSpecificExpandEntityType.addWeaponAndPlayerOnlyLootModifier(internal, name, weapon, matchDamage, false, modifier);
    }

    @ZenCodeType.Method
    public static void addWeaponAndPlayerOnlyLootModifier(EntityType<Entity> internal, String name, IItemStack weapon, boolean matchDamage, boolean matchNbt, ILootModifier modifier) {
        LootManager.INSTANCE.getModifierManager().register(name, LootConditions.allOf(ModifierSpecificExpandEntityType.makeForType(internal), ModifierSpecificExpandEntityType.makeForWeapon(weapon, matchDamage, matchNbt), ExpandLootItemKilledByPlayerCondition.create()), modifier);
    }

    private static LootItemCondition.Builder makeForType(EntityType<Entity> type) {
        return ExpandLootItemEntityPropertyCondition.create(LootContext.EntityTarget.THIS, ExpandEntityPredicate.create(type));
    }

    private static LootItemCondition.Builder makeForWeapon(IItemStack weapon, boolean matchDamage, boolean matchNbt) {
        CompoundTag tag;
        ItemPredicate.Builder item = ExpandItemPredicate.create(weapon);
        if (matchDamage) {
            item.m_151449_(ExpandMinMaxBoundsInts.exactly(weapon.getDamage()));
        }
        if (matchNbt && (tag = weapon.getInternal().m_41783_()) != null) {
            item.m_45075_(tag);
        }
        return ExpandLootItemEntityPropertyCondition.create(LootContext.EntityTarget.KILLER, ExpandEntityPredicate.create().m_36640_(ExpandEntityEquipmentPredicate.create().m_149928_(item).m_32207_()));
    }
}

