/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.script;

import com.blamejared.crafttweaker.impl.script.ScriptRecipe;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class ScriptSerializer
implements RecipeSerializer<ScriptRecipe> {
    public static final ScriptSerializer INSTANCE = new ScriptSerializer();
    public static final Codec<ScriptRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("fileName").forGetter(ScriptRecipe::getFileName), (App)Codec.STRING.fieldOf("content").forGetter(ScriptRecipe::getContent)).apply((Applicative)instance, ScriptRecipe::new));

    public Codec<ScriptRecipe> m_292673_() {
        return CODEC;
    }

    public ScriptRecipe fromNetwork(FriendlyByteBuf buffer) {
        String fileName = buffer.m_130277_();
        int parts = buffer.m_130242_();
        StringBuilder script = new StringBuilder();
        while (parts-- > 0) {
            script.append(buffer.m_130277_());
        }
        return new ScriptRecipe(fileName, script.toString());
    }

    public void toNetwork(FriendlyByteBuf buffer, ScriptRecipe recipe) {
        String contents = recipe.getContent();
        LinkedList split = Lists.newLinkedList((Iterable)Splitter.fixedLength((int)4095).split((CharSequence)contents));
        buffer.m_130070_(recipe.getFileName());
        buffer.m_130130_(split.size());
        split.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130070_(arg_0));
    }
}

