/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.registry.recipe;

import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.StringData;
import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

final class DefaultRecipeHandler
implements IRecipeHandler<Recipe<?>> {
    static final DefaultRecipeHandler INSTANCE = new DefaultRecipeHandler();

    DefaultRecipeHandler() {
    }

    @Override
    public String dumpToCommandString(IRecipeManager<? super Recipe<?>> manager, RegistryAccess registryAccess, RecipeHolder<Recipe<?>> holder) {
        Recipe recipe = holder.f_291008_();
        Optional<ResourceLocation> serializerKey = registryAccess.m_6632_(Registries.f_256764_).map(recipeSerializers -> recipeSerializers.m_7981_((Object)recipe.m_7707_()));
        Supplier<String> fallback = () -> {
            String ingredients = recipe.m_7527_().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", "));
            return String.format("~~ Recipe name: %s, Outputs: %s, Inputs: [%s], Recipe Class: %s, Recipe Serializer: %s ~~", holder.f_291676_(), ItemStackUtil.getCommandString(recipe.m_8043_(registryAccess)), ingredients, recipe.getClass().getName(), BuiltInRegistries.f_256769_.m_7981_((Object)recipe.m_7707_()));
        };
        if (serializerKey.isEmpty()) {
            return fallback.get();
        }
        try {
            MapData data = new MapData();
            data.put("type", new StringData(serializerKey.get().toString()));
            DataResult result = recipe.m_7707_().m_292673_().encode((Object)((Recipe)GenericUtil.uncheck(recipe)), (DynamicOps)IDataOps.INSTANCE, (Object)data);
            return result.result().map(it -> "<recipetype:%s>.addJsonRecipe(\"%s\", %s)".formatted(BuiltInRegistries.f_256990_.m_7981_(manager.getRecipeType()), holder.f_291676_(), it.toString())).orElseGet(fallback);
        }
        catch (Exception exception) {
            return fallback.get();
        }
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super Recipe<?>> manager, Recipe<?> firstRecipe, U secondRecipe) {
        return false;
    }

    @Override
    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super Recipe<?>> manager, RegistryAccess registryAccess, Recipe<?> recipe) {
        return Optional.empty();
    }

    @Override
    public Optional<Recipe<?>> recompose(IRecipeManager<? super Recipe<?>> manager, RegistryAccess registryAccess, IDecomposedRecipe recipe) {
        return Optional.empty();
    }
}

